/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.ditto.model.base.common.ConditionChecker;

public final class StreamingSessionIdentifier
implements CharSequence {
    static final String DELIMITER = "_-_";
    private final String clientSessionId;
    private final String serverSessionId;

    private StreamingSessionIdentifier(String clientSessionId, String serverSessionId) {
        this.clientSessionId = clientSessionId;
        this.serverSessionId = serverSessionId;
    }

    public static StreamingSessionIdentifier of(CharSequence streamingSessionIdentifier) {
        ConditionChecker.checkNotNull((Object)streamingSessionIdentifier, (String)"streamingSessionIdentifier");
        if (streamingSessionIdentifier instanceof StreamingSessionIdentifier) {
            return (StreamingSessionIdentifier)streamingSessionIdentifier;
        }
        String combinedSessionId = streamingSessionIdentifier.toString();
        int delimiterIdx = combinedSessionId.indexOf(DELIMITER);
        if (delimiterIdx < 0) {
            throw new IllegalArgumentException("Combined streaming session identifier does not contain the required  delimiter: _-_");
        }
        String clientSessionId = combinedSessionId.substring(0, delimiterIdx);
        String serverSessionId = combinedSessionId.substring(delimiterIdx + DELIMITER.length());
        return StreamingSessionIdentifier.of(clientSessionId, serverSessionId);
    }

    public static StreamingSessionIdentifier of(CharSequence clientSessionId, CharSequence serverSessionId) {
        ConditionChecker.checkNotNull((Object)clientSessionId, (String)"clientSessionId");
        ConditionChecker.checkNotNull((Object)serverSessionId, (String)"serverSessionId");
        return new StreamingSessionIdentifier(clientSessionId.toString(), serverSessionId.toString());
    }

    public String getClientSessionId() {
        return this.clientSessionId;
    }

    public String getServerSessionId() {
        return this.serverSessionId;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public boolean equals(@Nullable Object o) {
        Class<?> otherClass;
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        Class<?> thisClass = this.getClass();
        if (thisClass == (otherClass = o.getClass())) {
            StreamingSessionIdentifier that = (StreamingSessionIdentifier)o;
            return Objects.equals(this.clientSessionId, that.clientSessionId) && Objects.equals(this.serverSessionId, that.serverSessionId);
        }
        return Objects.equals(this.toString(), o.toString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    @Override
    public String toString() {
        return this.clientSessionId + DELIMITER + this.serverSessionId;
    }
}

