/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.services.gateway.streaming.StreamControlMessage;
import org.eclipse.ditto.services.models.concierge.streaming.StreamingType;

public final class StartStreaming
implements StreamControlMessage {
    private final StreamingType streamingType;
    private final String connectionCorrelationId;
    private final AuthorizationContext authorizationContext;
    private final List<String> namespaces;
    @Nullable
    private final String filter;
    @Nullable
    private final JsonFieldSelector extraFields;

    private StartStreaming(StartStreamingBuilder builder) {
        this.streamingType = builder.streamingType;
        this.connectionCorrelationId = builder.connectionCorrelationId;
        this.authorizationContext = builder.authorizationContext;
        Collection<String> namespacesFromBuilder = builder.namespaces;
        this.namespaces = null != namespacesFromBuilder ? List.copyOf(namespacesFromBuilder) : Collections.emptyList();
        this.filter = Objects.toString(builder.filter, null);
        this.extraFields = builder.extraFields;
    }

    public static StartStreamingBuilder getBuilder(StreamingType streamingType, CharSequence connectionCorrelationId, AuthorizationContext authorizationContext) {
        return new StartStreamingBuilder(streamingType, connectionCorrelationId, authorizationContext);
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }

    public String getConnectionCorrelationId() {
        return this.connectionCorrelationId;
    }

    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationContext;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public Optional<JsonFieldSelector> getExtraFields() {
        return Optional.ofNullable(this.extraFields);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartStreaming that = (StartStreaming)o;
        return this.streamingType == that.streamingType && Objects.equals(this.connectionCorrelationId, that.connectionCorrelationId) && Objects.equals(this.authorizationContext, that.authorizationContext) && Objects.equals(this.namespaces, that.namespaces) && Objects.equals(this.filter, that.filter) && Objects.equals(this.extraFields, that.extraFields);
    }

    public int hashCode() {
        return Objects.hash(this.streamingType, this.connectionCorrelationId, this.authorizationContext, this.namespaces, this.filter, this.extraFields);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [streamingType=" + this.streamingType + ", connectionCorrelationId=" + this.connectionCorrelationId + ", authorizationContext=" + this.authorizationContext + ", namespaces=" + this.namespaces + ", eventFilter=" + this.filter + ", extraFields=" + this.extraFields + "]";
    }

    @NotThreadSafe
    public static final class StartStreamingBuilder {
        private final StreamingType streamingType;
        private final String connectionCorrelationId;
        private final AuthorizationContext authorizationContext;
        @Nullable
        private Collection<String> namespaces;
        @Nullable
        private CharSequence filter;
        @Nullable
        private JsonFieldSelector extraFields;

        private StartStreamingBuilder(StreamingType streamingType, CharSequence connectionCorrelationId, AuthorizationContext authorizationContext) {
            this.streamingType = (StreamingType)ConditionChecker.checkNotNull((Object)streamingType, (String)"streamingType");
            this.connectionCorrelationId = ((CharSequence)ConditionChecker.checkNotNull((Object)connectionCorrelationId, (String)"connectionCorrelationId")).toString();
            this.authorizationContext = (AuthorizationContext)ConditionChecker.checkNotNull((Object)authorizationContext, (String)"authorizationContext");
            this.namespaces = null;
            this.filter = null;
            this.extraFields = null;
        }

        public StartStreamingBuilder withNamespaces(@Nullable Collection<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        public StartStreamingBuilder withFilter(@Nullable CharSequence filter) {
            this.filter = filter;
            return this;
        }

        public StartStreamingBuilder withExtraFields(@Nullable JsonFieldSelector extraFields) {
            this.extraFields = extraFields;
            return this;
        }

        public StartStreaming build() {
            return new StartStreaming(this);
        }
    }
}

