/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.japi.pf.DeciderBuilder;
import akka.japi.pf.ReceiveBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.model.jwt.ImmutableJsonWebToken;
import org.eclipse.ditto.model.jwt.JsonWebToken;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtAuthenticationFactory;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtAuthorizationContextProvider;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtValidator;
import org.eclipse.ditto.services.gateway.streaming.Connect;
import org.eclipse.ditto.services.gateway.streaming.DefaultStreamingConfig;
import org.eclipse.ditto.services.gateway.streaming.InvalidJwt;
import org.eclipse.ditto.services.gateway.streaming.Jwt;
import org.eclipse.ditto.services.gateway.streaming.RefreshSession;
import org.eclipse.ditto.services.gateway.streaming.StartStreaming;
import org.eclipse.ditto.services.gateway.streaming.StopStreaming;
import org.eclipse.ditto.services.gateway.streaming.StreamingConfig;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSessionActor;
import org.eclipse.ditto.services.models.concierge.pubsub.DittoProtocolSub;
import org.eclipse.ditto.services.utils.akka.actors.ModifyConfigBehavior;
import org.eclipse.ditto.services.utils.akka.actors.RetrieveConfigBehavior;
import org.eclipse.ditto.services.utils.akka.logging.DittoDiagnosticLoggingAdapter;
import org.eclipse.ditto.services.utils.akka.logging.DittoLoggerFactory;
import org.eclipse.ditto.services.utils.metrics.DittoMetrics;
import org.eclipse.ditto.services.utils.metrics.instruments.gauge.Gauge;
import org.eclipse.ditto.signals.base.Signal;

public final class StreamingActor
extends AbstractActorWithTimers
implements RetrieveConfigBehavior,
ModifyConfigBehavior {
    public static final String ACTOR_NAME = "streaming";
    private final DittoProtocolSub dittoProtocolSub;
    private final ActorRef commandRouter;
    private final Gauge streamingSessionsCounter;
    private final JwtValidator jwtValidator;
    private final JwtAuthorizationContextProvider jwtAuthorizationContextProvider;
    private final DittoDiagnosticLoggingAdapter logger = DittoLoggerFactory.getDiagnosticLoggingAdapter((Actor)this);
    private final SupervisorStrategy strategy = new OneForOneStrategy(true, DeciderBuilder.match(Throwable.class, e -> {
        this.logger.error(e, "Escalating above actor!");
        return SupervisorStrategy.escalate();
    }).matchAny(e -> {
        this.logger.error("Unknown message:'{}'! Escalating above actor!", e);
        return SupervisorStrategy.escalate();
    }).build());
    private StreamingConfig streamingConfig;

    private StreamingActor(DittoProtocolSub dittoProtocolSub, ActorRef commandRouter, JwtAuthenticationFactory jwtAuthenticationFactory, StreamingConfig streamingConfig) {
        this.dittoProtocolSub = dittoProtocolSub;
        this.commandRouter = commandRouter;
        this.streamingConfig = streamingConfig;
        this.streamingSessionsCounter = DittoMetrics.gauge((String)"streaming_sessions_count");
        this.jwtValidator = jwtAuthenticationFactory.getJwtValidator();
        this.jwtAuthorizationContextProvider = jwtAuthenticationFactory.newJwtAuthorizationContextProvider();
        this.scheduleScrapeStreamSessionsCounter();
    }

    public static Props props(DittoProtocolSub dittoProtocolSub, ActorRef commandRouter, JwtAuthenticationFactory jwtAuthenticationFactory, StreamingConfig streamingConfig) {
        return Props.create(StreamingActor.class, (Object[])new Object[]{dittoProtocolSub, commandRouter, jwtAuthenticationFactory, streamingConfig});
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.strategy;
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(Connect.class, connect -> {
            ActorRef eventAndResponsePublisher = connect.getEventAndResponsePublisher();
            eventAndResponsePublisher.forward(connect, (ActorContext)this.getContext());
            String connectionCorrelationId = connect.getConnectionCorrelationId();
            this.getContext().actorOf(StreamingSessionActor.props(connect, this.dittoProtocolSub, eventAndResponsePublisher), connectionCorrelationId);
        }).match(StartStreaming.class, startStreaming -> this.forwardToSessionActor(startStreaming.getConnectionCorrelationId(), startStreaming)).match(StopStreaming.class, stopStreaming -> this.forwardToSessionActor(stopStreaming.getConnectionCorrelationId(), stopStreaming)).match(Jwt.class, this::refreshWebSocketSession).build().orElse(this.retrieveConfigBehavior()).orElse(this.modifyConfigBehavior()).orElse(ReceiveBuilder.create().match(Signal.class, signal -> {
            DittoHeaders dittoHeaders = signal.getDittoHeaders();
            Optional originOpt = dittoHeaders.getOrigin();
            if (originOpt.isPresent()) {
                String origin = (String)originOpt.get();
                Optional sessionActor = this.getContext().findChild(origin);
                if (sessionActor.isPresent()) {
                    ActorRef sender = dittoHeaders.isResponseRequired() ? (ActorRef)sessionActor.get() : ActorRef.noSender();
                    this.commandRouter.tell(signal, sender);
                } else {
                    this.logger.withCorrelationId((WithDittoHeaders)signal).debug("No session actor found for origin <{}>.", (Object)origin);
                }
            } else {
                this.logger.withCorrelationId((WithDittoHeaders)signal).warning("Signal is missing the required origin header!");
            }
        }).matchEquals((Object)Control.RETRIEVE_WEBSOCKET_CONFIG, this::replyWebSocketConfig).matchEquals((Object)Control.SCRAPE_STREAM_COUNTER, this::updateStreamingSessionsCounter).match(DittoRuntimeException.class, cre -> {
            Optional originOpt = cre.getDittoHeaders().getOrigin();
            if (originOpt.isPresent()) {
                this.forwardToSessionActor((String)originOpt.get(), cre);
            } else {
                this.logger.withCorrelationId((WithDittoHeaders)cre).warning("Unhandled DittoRuntimeException: <{}: {}>", (Object)cre.getClass().getSimpleName(), (Object)cre.getMessage());
            }
        }).matchAny(any -> this.logger.warning("Got unknown message: '{}'", any)).build());
    }

    public Config getConfig() {
        return this.streamingConfig.render().getConfig(ACTOR_NAME);
    }

    public Config setConfig(Config config) {
        this.streamingConfig = DefaultStreamingConfig.of(config.atKey(ACTOR_NAME).withFallback((ConfigMergeable)this.streamingConfig.render()));
        this.scheduleScrapeStreamSessionsCounter();
        return this.streamingConfig.render();
    }

    private void refreshWebSocketSession(Jwt jwt) {
        String connectionCorrelationId = jwt.getConnectionCorrelationId();
        JsonWebToken jsonWebToken = ImmutableJsonWebToken.fromToken((String)jwt.toString());
        this.jwtValidator.validate(jsonWebToken).thenAccept(binaryValidationResult -> {
            if (binaryValidationResult.isValid()) {
                AuthorizationContext authorizationContext = this.jwtAuthorizationContextProvider.getAuthorizationContext(jsonWebToken);
                this.forwardToSessionActor(connectionCorrelationId, new RefreshSession(connectionCorrelationId, jsonWebToken.getExpirationTime(), authorizationContext));
            } else {
                this.forwardToSessionActor(connectionCorrelationId, InvalidJwt.getInstance());
            }
        });
    }

    private void forwardToSessionActor(String connectionCorrelationId, Object object) {
        if (object instanceof WithDittoHeaders) {
            this.logger.setCorrelationId((WithDittoHeaders)object);
        }
        this.logger.debug("Forwarding to session actor '{}': {}", (Object)connectionCorrelationId, object);
        this.logger.discardCorrelationId();
        this.getContext().actorSelection(connectionCorrelationId).forward(object, (ActorContext)this.getContext());
    }

    private void scheduleScrapeStreamSessionsCounter() {
        this.getTimers().startPeriodicTimer((Object)Control.SCRAPE_STREAM_COUNTER, (Object)Control.SCRAPE_STREAM_COUNTER, this.streamingConfig.getSessionCounterScrapeInterval());
    }

    private void replyWebSocketConfig(Control trigger) {
        this.getSender().tell((Object)this.streamingConfig.getWebsocketConfig(), this.getSelf());
    }

    private void updateStreamingSessionsCounter(Control trigger) {
        if (this.getContext() != null) {
            this.streamingSessionsCounter.set(Long.valueOf(StreamSupport.stream(this.getContext().getChildren().spliterator(), false).count()));
        }
    }

    public static enum Control {
        SCRAPE_STREAM_COUNTER,
        RETRIEVE_WEBSOCKET_CONFIG;

    }
}

