/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.services.gateway.streaming.StreamControlMessage;

public final class Jwt
implements StreamControlMessage {
    private final String stringRepresentation;
    private final String connectionCorrelationId;

    private Jwt(String stringRepresentation, CharSequence connectionCorrelationId) {
        this.connectionCorrelationId = ((CharSequence)ConditionChecker.checkNotNull((Object)connectionCorrelationId, (String)"connectionCorrelationId")).toString();
        this.stringRepresentation = (String)ConditionChecker.checkNotNull((Object)stringRepresentation, (String)"stringRepresentation");
    }

    public static Jwt newInstance(String tokenStringRepresentation, CharSequence connectionCorrelationId) {
        return new Jwt(tokenStringRepresentation, connectionCorrelationId);
    }

    public String getConnectionCorrelationId() {
        return this.connectionCorrelationId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Jwt jwtToken = (Jwt)o;
        return Objects.equals(this.connectionCorrelationId, jwtToken.connectionCorrelationId) && Objects.equals(this.stringRepresentation, jwtToken.stringRepresentation);
    }

    public int hashCode() {
        return Objects.hash(this.connectionCorrelationId, this.stringRepresentation);
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

