/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.services.base.config.DefaultSignalEnrichmentConfig;
import org.eclipse.ditto.services.base.config.SignalEnrichmentConfig;
import org.eclipse.ditto.services.gateway.streaming.DefaultWebsocketConfig;
import org.eclipse.ditto.services.gateway.streaming.StreamingConfig;
import org.eclipse.ditto.services.gateway.streaming.WebsocketConfig;
import org.eclipse.ditto.services.utils.config.ConfigWithFallback;
import org.eclipse.ditto.services.utils.config.KnownConfigValue;
import org.eclipse.ditto.services.utils.config.ScopedConfig;

@Immutable
public final class DefaultStreamingConfig
implements StreamingConfig {
    private final Duration sessionCounterScrapeInterval;
    private final int parallelism;
    private final WebsocketConfig websocketConfig;
    private final SignalEnrichmentConfig signalEnrichmentConfig;

    private DefaultStreamingConfig(ScopedConfig scopedConfig) {
        this.sessionCounterScrapeInterval = scopedConfig.getDuration(StreamingConfig.StreamingConfigValue.SESSION_COUNTER_SCRAPE_INTERVAL.getConfigPath());
        this.parallelism = scopedConfig.getInt(StreamingConfig.StreamingConfigValue.PARALLELISM.getConfigPath());
        this.websocketConfig = DefaultWebsocketConfig.of((Config)scopedConfig);
        this.signalEnrichmentConfig = DefaultSignalEnrichmentConfig.of((Config)scopedConfig);
    }

    public static StreamingConfig of(Config config) {
        return new DefaultStreamingConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)"streaming", (KnownConfigValue[])StreamingConfig.StreamingConfigValue.values()));
    }

    @Override
    public Duration getSessionCounterScrapeInterval() {
        return this.sessionCounterScrapeInterval;
    }

    @Override
    public WebsocketConfig getWebsocketConfig() {
        return this.websocketConfig;
    }

    @Override
    public SignalEnrichmentConfig getSignalEnrichmentConfig() {
        return this.signalEnrichmentConfig;
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultStreamingConfig that = (DefaultStreamingConfig)o;
        return this.parallelism == that.parallelism && Objects.equals(this.sessionCounterScrapeInterval, that.sessionCounterScrapeInterval) && Objects.equals(this.signalEnrichmentConfig, that.signalEnrichmentConfig) && Objects.equals(this.websocketConfig, that.websocketConfig);
    }

    public int hashCode() {
        return Objects.hash(this.parallelism, this.sessionCounterScrapeInterval, this.signalEnrichmentConfig, this.websocketConfig);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [sessionCounterScrapeInterval=" + this.sessionCounterScrapeInterval + ", parallelism=" + this.parallelism + ", signalEnrichmentConfig=" + this.signalEnrichmentConfig + ", websocketConfig=" + this.websocketConfig + "]";
    }
}

