/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.HashMap;
import org.eclipse.ditto.services.base.config.ThrottlingConfig;
import org.eclipse.ditto.services.utils.config.KnownConfigValue;

public interface WebsocketConfig {
    public static final String CONFIG_PATH = "websocket";

    public int getSubscriberBackpressureQueueSize();

    public int getPublisherBackpressureBufferSize();

    public double getThrottlingRejectionFactor();

    public ThrottlingConfig getThrottlingConfig();

    default public Config render() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put(WebsocketConfigValue.SUBSCRIBER_BACKPRESSURE_QUEUE_SIZE.getConfigPath(), this.getSubscriberBackpressureQueueSize());
        map.put(WebsocketConfigValue.PUBLISHER_BACKPRESSURE_BUFFER_SIZE.getConfigPath(), this.getPublisherBackpressureBufferSize());
        map.put(WebsocketConfigValue.THROTTLING_REJECTION_FACTOR.getConfigPath(), this.getThrottlingRejectionFactor());
        return ConfigFactory.parseMap(map).withFallback((ConfigMergeable)this.getThrottlingConfig().render()).atKey(CONFIG_PATH);
    }

    public static enum WebsocketConfigValue implements KnownConfigValue
    {
        SUBSCRIBER_BACKPRESSURE_QUEUE_SIZE("subscriber.backpressure-queue-size", 100),
        PUBLISHER_BACKPRESSURE_BUFFER_SIZE("publisher.backpressure-buffer-size", 200),
        THROTTLING_REJECTION_FACTOR("throttling-rejection-factor", 1.25);

        private final String path;
        private final Object defaultValue;

        private WebsocketConfigValue(String thePath, Object theDefaultValue) {
            this.path = thePath;
            this.defaultValue = theDefaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getConfigPath() {
            return this.path;
        }
    }
}

