/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.time.Duration;
import java.util.HashMap;
import org.eclipse.ditto.services.gateway.streaming.WebsocketConfig;
import org.eclipse.ditto.services.utils.config.KnownConfigValue;

public interface StreamingConfig {
    public static final String CONFIG_PATH = "streaming";

    public Duration getSessionCounterScrapeInterval();

    public WebsocketConfig getWebsocketConfig();

    default public Config render() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(StreamingConfigValue.SESSION_COUNTER_SCRAPE_INTERVAL.getConfigPath(), this.getSessionCounterScrapeInterval().toMillis() + "ms");
        return ConfigFactory.parseMap(map).withFallback((ConfigMergeable)this.getWebsocketConfig().render()).atKey(CONFIG_PATH);
    }

    public static enum StreamingConfigValue implements KnownConfigValue
    {
        SESSION_COUNTER_SCRAPE_INTERVAL("session-counter-scrape-interval", Duration.ofSeconds(30L));

        private final String path;
        private final Object defaultValue;

        private StreamingConfigValue(String thePath, Object theDefaultValue) {
            this.path = thePath;
            this.defaultValue = theDefaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getConfigPath() {
            return this.path;
        }
    }
}

