/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import com.typesafe.config.Config;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.services.base.config.ThrottlingConfig;
import org.eclipse.ditto.services.gateway.streaming.WebsocketConfig;
import org.eclipse.ditto.services.utils.config.ConfigWithFallback;
import org.eclipse.ditto.services.utils.config.KnownConfigValue;
import org.eclipse.ditto.services.utils.config.ScopedConfig;

@Immutable
final class DefaultWebsocketConfig
implements WebsocketConfig {
    private final int subscriberBackpressureQueueSize;
    private final int publisherBackpressureBufferSize;
    private final double throttlingRejectionFactor;
    private final ThrottlingConfig throttlingConfig;

    private DefaultWebsocketConfig(ScopedConfig scopedConfig) {
        this.subscriberBackpressureQueueSize = scopedConfig.getInt(WebsocketConfig.WebsocketConfigValue.SUBSCRIBER_BACKPRESSURE_QUEUE_SIZE.getConfigPath());
        this.publisherBackpressureBufferSize = scopedConfig.getInt(WebsocketConfig.WebsocketConfigValue.PUBLISHER_BACKPRESSURE_BUFFER_SIZE.getConfigPath());
        this.throttlingRejectionFactor = scopedConfig.getDouble(WebsocketConfig.WebsocketConfigValue.THROTTLING_REJECTION_FACTOR.getConfigPath());
        this.throttlingConfig = ThrottlingConfig.of((Config)scopedConfig);
    }

    public static WebsocketConfig of(Config config) {
        return new DefaultWebsocketConfig((ScopedConfig)ConfigWithFallback.newInstance((Config)config, (String)"websocket", (KnownConfigValue[])WebsocketConfig.WebsocketConfigValue.values()));
    }

    @Override
    public int getSubscriberBackpressureQueueSize() {
        return this.subscriberBackpressureQueueSize;
    }

    @Override
    public int getPublisherBackpressureBufferSize() {
        return this.publisherBackpressureBufferSize;
    }

    @Override
    public double getThrottlingRejectionFactor() {
        return this.throttlingRejectionFactor;
    }

    @Override
    public ThrottlingConfig getThrottlingConfig() {
        return this.throttlingConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultWebsocketConfig that = (DefaultWebsocketConfig)o;
        return this.subscriberBackpressureQueueSize == that.subscriberBackpressureQueueSize && this.publisherBackpressureBufferSize == that.publisherBackpressureBufferSize && Double.compare(this.throttlingRejectionFactor, that.throttlingRejectionFactor) == 0 && Objects.equals(this.throttlingConfig, that.throttlingConfig);
    }

    public int hashCode() {
        return Objects.hash(this.subscriberBackpressureQueueSize, this.publisherBackpressureBufferSize, this.throttlingRejectionFactor, this.throttlingConfig);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [subscriberBackpressureQueueSize=" + this.subscriberBackpressureQueueSize + ", publisherBackpressureBufferSize=" + this.publisherBackpressureBufferSize + ", throttlingRejectionFactor=" + this.throttlingRejectionFactor + ", throttlingConfig=" + this.throttlingConfig + "]";
    }
}

