/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.AbstractActor;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.event.DiagnosticLoggingAdapter;
import akka.japi.pf.DeciderBuilder;
import akka.japi.pf.ReceiveBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.services.gateway.streaming.Connect;
import org.eclipse.ditto.services.gateway.streaming.StartStreaming;
import org.eclipse.ditto.services.gateway.streaming.StopStreaming;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSessionActor;
import org.eclipse.ditto.services.utils.akka.LogUtil;
import org.eclipse.ditto.services.utils.metrics.DittoMetrics;
import org.eclipse.ditto.services.utils.metrics.instruments.gauge.Gauge;
import org.eclipse.ditto.signals.base.Signal;
import scala.concurrent.ExecutionContext;

public final class StreamingActor
extends AbstractActor {
    public static final String ACTOR_NAME = "streaming";
    private static final Duration SESSIONS_COUNTER_SCRAPE_INTERVAL = Duration.ofSeconds(30L);
    private final DiagnosticLoggingAdapter logger = LogUtil.obtain((Actor)this);
    private final ActorRef pubSubMediator;
    private final ActorRef commandRouter;
    private final SupervisorStrategy strategy = new OneForOneStrategy(true, DeciderBuilder.match(Throwable.class, e -> {
        this.logger.error(e, "Escalating above actor!");
        return SupervisorStrategy.escalate();
    }).matchAny(e -> {
        this.logger.error("Unknown message:'{}'! Escalating above actor!", e);
        return SupervisorStrategy.escalate();
    }).build());
    private final Gauge streamingSessionsCounter;
    private final Cancellable sessionCounterScheduler;

    private StreamingActor(ActorRef pubSubMediator, ActorRef commandRouter) {
        this.pubSubMediator = pubSubMediator;
        this.commandRouter = commandRouter;
        this.streamingSessionsCounter = DittoMetrics.gauge((String)"streaming_sessions_count");
        this.sessionCounterScheduler = this.getContext().getSystem().getScheduler().schedule(SESSIONS_COUNTER_SCRAPE_INTERVAL, SESSIONS_COUNTER_SCRAPE_INTERVAL, this::updateStreamingSessionsCounter, (ExecutionContext)this.getContext().getDispatcher());
    }

    private void updateStreamingSessionsCounter() {
        if (this.getContext() != null) {
            this.streamingSessionsCounter.set(Long.valueOf(StreamSupport.stream(this.getContext().getChildren().spliterator(), false).count()));
        }
    }

    public void postStop() {
        this.sessionCounterScheduler.cancel();
    }

    public static Props props(ActorRef pubSubMediator, ActorRef commandRouter) {
        return Props.create(StreamingActor.class, (Object[])new Object[]{pubSubMediator, commandRouter});
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.strategy;
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(Connect.class, connect -> {
            ActorRef eventAndResponsePublisher = connect.getEventAndResponsePublisher();
            eventAndResponsePublisher.forward(connect, (ActorContext)this.getContext());
            String connectionCorrelationId = connect.getConnectionCorrelationId();
            this.getContext().actorOf(StreamingSessionActor.props(connectionCorrelationId, connect.getType(), this.pubSubMediator, eventAndResponsePublisher), connectionCorrelationId);
        }).match(StartStreaming.class, startStreaming -> this.forwardToSessionActor(startStreaming.getConnectionCorrelationId(), startStreaming)).match(StopStreaming.class, stopStreaming -> this.forwardToSessionActor(stopStreaming.getConnectionCorrelationId(), stopStreaming)).match(Signal.class, signal -> {
            Optional originOpt = signal.getDittoHeaders().getOrigin();
            if (originOpt.isPresent()) {
                String origin = (String)originOpt.get();
                ActorRef sessionActor = this.getContext().getChild(origin);
                if (sessionActor != null) {
                    this.commandRouter.tell(signal, sessionActor);
                } else {
                    this.logger.debug("No session actor found for origin: {}", (Object)origin);
                }
            } else {
                this.logger.warning("Signal is missing the required origin header: {}", (Object)signal.getDittoHeaders().getCorrelationId());
            }
        }).match(DittoRuntimeException.class, cre -> {
            Optional originOpt = cre.getDittoHeaders().getOrigin();
            if (originOpt.isPresent()) {
                this.forwardToSessionActor((String)originOpt.get(), cre);
            } else {
                this.logger.warning("Unhandled DittoRuntimeException: <{}: {}>", (Object)((Object)cre).getClass().getSimpleName(), (Object)cre.getMessage());
            }
        }).matchAny(any -> this.logger.warning("Got unknown message: '{}'", any)).build();
    }

    private void forwardToSessionActor(String connectionCorrelationId, Object object) {
        if (object instanceof WithDittoHeaders) {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (WithDittoHeaders)((WithDittoHeaders)object), (LogUtil.MdcField[])new LogUtil.MdcField[0]);
        } else {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)null, (LogUtil.MdcField[])new LogUtil.MdcField[0]);
        }
        this.logger.debug("Forwarding to session actor '{}': {}", (Object)connectionCorrelationId, object);
        this.getContext().actorSelection(connectionCorrelationId).forward(object, (ActorContext)this.getContext());
    }
}

