/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.AbstractActor;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.event.DiagnosticLoggingAdapter;
import akka.japi.Creator;
import akka.japi.pf.DeciderBuilder;
import akka.japi.pf.ReceiveBuilder;
import java.util.Optional;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.services.gateway.streaming.Connect;
import org.eclipse.ditto.services.gateway.streaming.StartStreaming;
import org.eclipse.ditto.services.gateway.streaming.StopStreaming;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSessionActor;
import org.eclipse.ditto.services.utils.akka.LogUtil;
import org.eclipse.ditto.signals.base.Signal;

public final class StreamingActor
extends AbstractActor {
    public static final String ACTOR_NAME = "streaming";
    private final DiagnosticLoggingAdapter logger = LogUtil.obtain((Actor)this);
    private final ActorRef pubSubMediator;
    private final ActorRef commandRouter;
    private final SupervisorStrategy strategy = new OneForOneStrategy(true, DeciderBuilder.match(Throwable.class, e -> {
        this.logger.error(e, "Escalating above actor!");
        return SupervisorStrategy.escalate();
    }).matchAny(e -> {
        this.logger.error("Unknown message:'{}'! Escalating above actor!", e);
        return SupervisorStrategy.escalate();
    }).build());

    private StreamingActor(ActorRef pubSubMediator, ActorRef commandRouter) {
        this.pubSubMediator = pubSubMediator;
        this.commandRouter = commandRouter;
    }

    public static Props props(final ActorRef pubSubMediator, final ActorRef commandRouter) {
        return Props.create(StreamingActor.class, (Creator)new Creator<StreamingActor>(){
            private static final long serialVersionUID = 1L;

            public StreamingActor create() {
                return new StreamingActor(pubSubMediator, commandRouter);
            }
        });
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.strategy;
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(Connect.class, connect -> {
            ActorRef eventAndResponsePublisher = connect.getEventAndResponsePublisher();
            eventAndResponsePublisher.forward(connect, (ActorContext)this.getContext());
            String connectionCorrelationId = connect.getConnectionCorrelationId();
            this.getContext().actorOf(StreamingSessionActor.props(connectionCorrelationId, connect.getType(), this.pubSubMediator, eventAndResponsePublisher), connectionCorrelationId);
        }).match(StartStreaming.class, startStreaming -> this.forwardToSessionActor(startStreaming.getConnectionCorrelationId(), startStreaming)).match(StopStreaming.class, stopStreaming -> this.forwardToSessionActor(stopStreaming.getConnectionCorrelationId(), stopStreaming)).match(Signal.class, signal -> {
            Optional originOpt = signal.getDittoHeaders().getOrigin();
            if (originOpt.isPresent()) {
                String origin = (String)originOpt.get();
                ActorRef sessionActor = this.getContext().getChild(origin);
                if (sessionActor != null) {
                    this.commandRouter.tell(signal, sessionActor);
                } else {
                    this.logger.debug("No session actor found for origin: {}", (Object)origin);
                }
            } else {
                this.logger.warning("Signal is missing the required origin header: {}", (Object)signal.getDittoHeaders().getCorrelationId());
            }
        }).match(DittoRuntimeException.class, cre -> {
            Optional originOpt = cre.getDittoHeaders().getOrigin();
            if (originOpt.isPresent()) {
                this.forwardToSessionActor((String)originOpt.get(), cre);
            } else {
                this.logger.warning("Unhandled DittoRuntimeException: <{}: {}>", (Object)((Object)cre).getClass().getSimpleName(), (Object)cre.getMessage());
            }
        }).matchAny(any -> this.logger.warning("Got unknown message: '{}'", any)).build();
    }

    private void forwardToSessionActor(String connectionCorrelationId, Object object) {
        if (object instanceof WithDittoHeaders) {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (WithDittoHeaders)((WithDittoHeaders)object));
        } else {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (CharSequence)null);
        }
        this.logger.debug("Forwarding to session actor '{}': {}", (Object)connectionCorrelationId, object);
        this.getContext().actorSelection(connectionCorrelationId).forward(object, (ActorContext)this.getContext());
    }
}

