/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.services.models.concierge.streaming.StreamingType;

public final class StartStreaming {
    private final StreamingType streamingType;
    private final String connectionCorrelationId;
    private final AuthorizationContext authorizationContext;
    private final List<String> namespaces;
    @Nullable
    private final String filter;

    public StartStreaming(StreamingType streamingType, String connectionCorrelationId, AuthorizationContext authorizationContext, List<String> namespaces, @Nullable String filter) {
        this.streamingType = streamingType;
        this.connectionCorrelationId = connectionCorrelationId;
        this.authorizationContext = authorizationContext;
        this.namespaces = Collections.unmodifiableList(new ArrayList<String>(namespaces));
        this.filter = filter;
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }

    public String getConnectionCorrelationId() {
        return this.connectionCorrelationId;
    }

    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationContext;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartStreaming that = (StartStreaming)o;
        return this.streamingType == that.streamingType && Objects.equals(this.connectionCorrelationId, that.connectionCorrelationId) && Objects.equals(this.authorizationContext, that.authorizationContext) && Objects.equals(this.namespaces, that.namespaces) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.streamingType, this.connectionCorrelationId, this.authorizationContext, this.namespaces, this.filter);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [streamingType=" + this.streamingType + ", connectionCorrelationId=" + this.connectionCorrelationId + ", authorizationContext=" + this.authorizationContext + ", namespaces=" + this.namespaces + ", eventFilter=" + this.filter + "]";
    }
}

