/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.AbstractActor;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.DiagnosticLoggingAdapter;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.services.gateway.streaming.StartStreaming;
import org.eclipse.ditto.services.gateway.streaming.StopStreaming;
import org.eclipse.ditto.services.gateway.streaming.StreamingAck;
import org.eclipse.ditto.services.gateway.streaming.StreamingType;
import org.eclipse.ditto.services.utils.akka.LogUtil;
import org.eclipse.ditto.signals.base.Signal;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;
import org.eclipse.ditto.signals.events.base.Event;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

final class StreamingSessionActor
extends AbstractActor {
    private static final int MAX_SUBSCRIBE_TIMEOUT_MS = 2500;
    private final DiagnosticLoggingAdapter logger = LogUtil.obtain((Actor)this);
    private final String connectionCorrelationId;
    private final String type;
    private final ActorRef pubSubMediator;
    private final ActorRef eventAndResponsePublisher;
    private final Set<StreamingType> outstandingSubscriptionAcks;
    private List<String> authorizationSubjects;

    private StreamingSessionActor(String connectionCorrelationId, String type, ActorRef pubSubMediator, ActorRef eventAndResponsePublisher) {
        this.connectionCorrelationId = connectionCorrelationId;
        this.type = type;
        this.pubSubMediator = pubSubMediator;
        this.eventAndResponsePublisher = eventAndResponsePublisher;
        this.outstandingSubscriptionAcks = new HashSet<StreamingType>();
        this.getContext().watch(eventAndResponsePublisher);
    }

    static Props props(final String connectionCorrelationId, final String type, final ActorRef pubSubMediator, final ActorRef eventAndResponsePublisher) {
        return Props.create(StreamingSessionActor.class, (Creator)new Creator<StreamingSessionActor>(){
            private static final long serialVersionUID = 1L;

            public StreamingSessionActor create() throws Exception {
                return new StreamingSessionActor(connectionCorrelationId, type, pubSubMediator, eventAndResponsePublisher);
            }
        });
    }

    public void postStop() throws Exception {
        LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)this.connectionCorrelationId);
        this.logger.info("Closing '{}' streaming session: {}", (Object)this.type, (Object)this.connectionCorrelationId);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(CommandResponse.class, response -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (WithDittoHeaders)response);
            this.logger.debug("Got 'CommandResponse' message in <{}> session, telling eventAndResponsePublisher about it: {}", (Object)this.type, response);
            this.eventAndResponsePublisher.forward(response, (ActorContext)this.getContext());
        }).match(Signal.class, this::handleSignal).match(DittoRuntimeException.class, cre -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (WithDittoHeaders)cre);
            this.logger.info("Got 'DittoRuntimeException' message in <{}> session, telling eventAndResponsePublisher about it: {}", (Object)this.type, cre);
            this.eventAndResponsePublisher.forward(cre, (ActorContext)this.getContext());
        }).match(StartStreaming.class, startStreaming -> {
            this.authorizationSubjects = startStreaming.getAuthorizationContext().getAuthorizationSubjectIds();
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)this.connectionCorrelationId);
            this.logger.debug("Got 'StartStreaming' message in <{}> session, subscribing for <{}> in Cluster..", (Object)this.type, (Object)startStreaming.getStreamingType().name());
            this.outstandingSubscriptionAcks.add(startStreaming.getStreamingType());
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(startStreaming.getStreamingType().getDistributedPubSubTopic(), this.connectionCorrelationId, this.getSelf()), this.getSelf());
        }).match(StopStreaming.class, stopStreaming -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)this.connectionCorrelationId);
            this.logger.debug("Got 'StopStreaming' message in <{}> session, unsubscribing from <{}> in Cluster..", (Object)this.type, (Object)stopStreaming.getStreamingType().name());
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Unsubscribe(stopStreaming.getStreamingType().getDistributedPubSubTopic(), this.connectionCorrelationId, this.getSelf()), this.getSelf());
        }).match(DistributedPubSubMediator.SubscribeAck.class, subscribeAck -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)this.connectionCorrelationId);
            String topic = subscribeAck.subscribe().topic();
            StreamingType streamingType = StreamingType.fromTopic(topic);
            ActorRef self = this.getSelf();
            this.getContext().getSystem().scheduler().scheduleOnce(FiniteDuration.apply((long)2500L, (TimeUnit)TimeUnit.MILLISECONDS), () -> this.acknowledgeSubscription(streamingType, self), (ExecutionContext)this.getContext().getSystem().dispatcher());
        }).match(DistributedPubSubMediator.UnsubscribeAck.class, unsubscribeAck -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)this.connectionCorrelationId);
            String topic = unsubscribeAck.unsubscribe().topic();
            StreamingType streamingType = StreamingType.fromTopic(topic);
            ActorRef self = this.getSelf();
            this.getContext().getSystem().scheduler().scheduleOnce(FiniteDuration.apply((long)2500L, (TimeUnit)TimeUnit.MILLISECONDS), () -> this.acknowledgeUnsubscription(streamingType, self), (ExecutionContext)this.getContext().getSystem().dispatcher());
        }).match(Terminated.class, terminated -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)this.connectionCorrelationId);
            this.logger.debug("eventAndResponsePublisher was terminated");
            this.logger.info("<{}> connection was closed, unsubscribing from Streams in Cluster..", (Object)this.type);
            Arrays.stream(StreamingType.values()).map(StreamingType::getDistributedPubSubTopic).forEach(topic -> this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Unsubscribe(topic, this.connectionCorrelationId, this.getSelf()), this.getSelf()));
            this.getContext().getSystem().scheduler().scheduleOnce(FiniteDuration.apply((long)1L, (TimeUnit)TimeUnit.SECONDS), this.getSelf(), (Object)PoisonPill.getInstance(), (ExecutionContext)this.getContext().dispatcher(), this.getSelf());
        }).matchAny(any -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)this.connectionCorrelationId);
            this.logger.warning("Got unknown message in '{}' session: '{}'", (Object)this.type, any);
        }).build();
    }

    private void handleSignal(Signal<?> signal) {
        LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, signal);
        this.acknowledgeSubscriptionForSignal(signal);
        DittoHeaders dittoHeaders = signal.getDittoHeaders();
        if (this.connectionCorrelationId.equals(dittoHeaders.getOrigin().orElse(null))) {
            this.logger.debug("Got Signal <{}> in <{}> session, but this was issued by this connection itself, not telling eventAndResponsePublisher about it", (Object)signal.getType(), (Object)this.type);
        } else if (this.authorizationSubjects != null && !Collections.disjoint(dittoHeaders.getReadSubjects(), this.authorizationSubjects)) {
            this.logger.debug("Got 'Live' Signal <{}> in <{}> session, telling eventAndResponsePublisher about it: {}", (Object)signal.getType(), (Object)this.type, signal);
            this.eventAndResponsePublisher.tell(signal, this.getSelf());
        }
    }

    private void acknowledgeSubscriptionForSignal(Signal liveSignal) {
        if (liveSignal instanceof MessageCommand && this.outstandingSubscriptionAcks.contains((Object)StreamingType.MESSAGES)) {
            this.acknowledgeSubscription(StreamingType.MESSAGES, this.getSelf());
        } else if (liveSignal instanceof Command && this.outstandingSubscriptionAcks.contains((Object)StreamingType.LIVE_COMMANDS)) {
            this.acknowledgeSubscription(StreamingType.LIVE_COMMANDS, this.getSelf());
        } else if (liveSignal instanceof Event && this.outstandingSubscriptionAcks.contains((Object)StreamingType.LIVE_EVENTS)) {
            this.acknowledgeSubscription(StreamingType.LIVE_EVENTS, this.getSelf());
        }
    }

    private void acknowledgeSubscription(StreamingType streamingType, ActorRef self) {
        this.outstandingSubscriptionAcks.remove((Object)streamingType);
        this.eventAndResponsePublisher.tell((Object)new StreamingAck(streamingType, true), self);
        this.logger.debug("Subscribed to Cluster <{}> in <{}> session", (Object)streamingType, (Object)this.type);
    }

    private void acknowledgeUnsubscription(StreamingType streamingType, ActorRef self) {
        this.eventAndResponsePublisher.tell((Object)new StreamingAck(streamingType, false), self);
        this.logger.debug("Unsubscribed from Cluster <{}> in <{}> session", (Object)streamingType, (Object)this.type);
    }
}

