/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.thingsearch.SortOptionEntry;

@Immutable
final class ImmutableSortOptionEntry
implements SortOptionEntry {
    private final JsonPointer propertyPath;
    private final SortOptionEntry.SortOrder sortOrder;

    ImmutableSortOptionEntry(CharSequence propertyPath, SortOptionEntry.SortOrder sortOrder) {
        this.propertyPath = JsonFactory.newPointer((CharSequence)((CharSequence)ConditionChecker.checkNotNull((Object)propertyPath, (String)"property path")));
        this.sortOrder = sortOrder;
    }

    public static ImmutableSortOptionEntry of(CharSequence propertyPath, SortOptionEntry.SortOrder sortOrder) {
        return new ImmutableSortOptionEntry(propertyPath, sortOrder);
    }

    public static ImmutableSortOptionEntry asc(CharSequence propertyPath) {
        return new ImmutableSortOptionEntry(propertyPath, SortOptionEntry.SortOrder.ASC);
    }

    public static ImmutableSortOptionEntry desc(CharSequence propertyPath) {
        return new ImmutableSortOptionEntry(propertyPath, SortOptionEntry.SortOrder.DESC);
    }

    @Override
    public JsonPointer getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public SortOptionEntry.SortOrder getOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSortOptionEntry that = (ImmutableSortOptionEntry)o;
        return Objects.equals(this.propertyPath, that.propertyPath) && this.sortOrder == that.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.propertyPath, this.sortOrder});
    }

    @Override
    public String toString() {
        return this.sortOrder.getName() + this.propertyPath.toString();
    }
}

