/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.thingsearch.ImmutableSortOptionEntry;
import org.eclipse.ditto.model.thingsearch.OptionVisitor;
import org.eclipse.ditto.model.thingsearch.SortOption;
import org.eclipse.ditto.model.thingsearch.SortOptionEntry;

@Immutable
final class ImmutableSortOption
implements SortOption {
    private final List<SortOptionEntry> entries;

    private ImmutableSortOption(List<SortOptionEntry> theEntries) {
        this.entries = Collections.unmodifiableList(new ArrayList<SortOptionEntry>(theEntries));
    }

    public static ImmutableSortOption of(List<SortOptionEntry> entries) {
        return new ImmutableSortOption((List)ConditionChecker.checkNotNull(entries, (String)"entries"));
    }

    @Override
    public void accept(OptionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<SortOptionEntry> getEntries() {
        return this.entries;
    }

    @Override
    public SortOption add(SortOptionEntry entry) {
        ConditionChecker.checkNotNull((Object)entry, (String)"entry to be added");
        ArrayList<SortOptionEntry> newEntries = new ArrayList<SortOptionEntry>(this.entries);
        newEntries.add(entry);
        return new ImmutableSortOption(newEntries);
    }

    @Override
    public SortOption add(CharSequence propertyPath, SortOptionEntry.SortOrder order) {
        return this.add(new ImmutableSortOptionEntry(propertyPath, order));
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Stream<SortOptionEntry> stream() {
        return this.entries.stream();
    }

    @Override
    public Iterator<SortOptionEntry> iterator() {
        return this.entries.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSortOption that = (ImmutableSortOption)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        String delimiter = ",";
        String prefix = "sort(";
        String suffix = ")";
        return this.stream().map(SortOptionEntry::toString).collect(Collectors.joining(",", "sort(", ")"));
    }
}

