/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.thingsearch.OptionVisitor;
import org.eclipse.ditto.model.thingsearch.SizeOption;

@Immutable
final class ImmutableSizeOption
implements SizeOption {
    static final int MAX_SIZE = 200;
    private final int size;

    private ImmutableSizeOption(int size) {
        this.size = size;
    }

    static ImmutableSizeOption of(int size) {
        return new ImmutableSizeOption(size);
    }

    @Override
    public void accept(OptionVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableSizeOption) {
            ImmutableSizeOption that = (ImmutableSizeOption)o;
            return this.size == that.size;
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public int hashCode() {
        return this.size;
    }

    @Override
    public String toString() {
        return "size(" + this.size + ")";
    }
}

