/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonArrayBuilder;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.thingsearch.ImmutableSearchResult;
import org.eclipse.ditto.model.thingsearch.SearchResult;
import org.eclipse.ditto.model.thingsearch.SearchResultBuilder;

@NotThreadSafe
final class ImmutableSearchResultBuilder
implements SearchResultBuilder {
    private final JsonArrayBuilder jsonArrayBuilder;
    @Nullable
    private Long offset;
    @Nullable
    private String cursor;

    private ImmutableSearchResultBuilder(JsonArrayBuilder theJsonArrayBuilder) {
        this.jsonArrayBuilder = theJsonArrayBuilder;
    }

    public static SearchResultBuilder newInstance() {
        return new ImmutableSearchResultBuilder(JsonFactory.newArrayBuilder()).nextPageOffset(-1L);
    }

    public static SearchResultBuilder of(SearchResult searchResult) {
        ConditionChecker.checkNotNull((Object)searchResult, (String)"search result");
        JsonArrayBuilder jsonArrayBuilder = JsonFactory.newArrayBuilder((Iterable)searchResult.getItems());
        Long nextPageOffset = searchResult.getNextPageOffset().orElse(null);
        String cursor = searchResult.getCursor().orElse(null);
        return new ImmutableSearchResultBuilder(jsonArrayBuilder).nextPageOffset(nextPageOffset).cursor(cursor);
    }

    @Override
    public SearchResultBuilder nextPageOffset(@Nullable Long nextPageOffset) {
        this.offset = nextPageOffset;
        return this;
    }

    @Override
    public SearchResultBuilder cursor(@Nullable String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Override
    public SearchResultBuilder add(JsonValue value, JsonValue ... furtherValues) {
        this.jsonArrayBuilder.add(value, furtherValues);
        return this;
    }

    @Override
    public SearchResultBuilder addAll(Iterable<? extends JsonValue> values) {
        this.jsonArrayBuilder.addAll(values);
        return this;
    }

    @Override
    public SearchResultBuilder remove(JsonValue value) {
        this.jsonArrayBuilder.remove(value);
        return this;
    }

    @Override
    public SearchResult build() {
        JsonArray searchResultsJsonArray = this.jsonArrayBuilder.build();
        return ImmutableSearchResult.of(searchResultsJsonArray, this.offset, this.cursor);
    }
}

