/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.thingsearch.SearchResult;

@Immutable
final class ImmutableSearchResult
implements SearchResult {
    private final JsonArray items;
    @Nullable
    private final Long nextPageOffset;
    @Nullable
    private final String cursor;

    private ImmutableSearchResult(JsonArray items, @Nullable Long nextPageOffset, @Nullable String cursor) {
        this.items = (JsonArray)ConditionChecker.checkNotNull((Object)items, (String)"items");
        this.nextPageOffset = nextPageOffset;
        this.cursor = cursor;
    }

    public static SearchResult empty() {
        return ImmutableSearchResult.of(JsonFactory.newArray(), -1L, null);
    }

    public static ImmutableSearchResult of(JsonArray items, @Nullable Long nextPageOffset, @Nullable String cursor) {
        return new ImmutableSearchResult(items, nextPageOffset, cursor);
    }

    public static ImmutableSearchResult fromJson(JsonObject jsonObject) {
        JsonArray extractedItems = (JsonArray)jsonObject.getValueOrThrow(SearchResult.JsonFields.ITEMS);
        Long extractedNextPageOffset = jsonObject.getValue(SearchResult.JsonFields.NEXT_PAGE_OFFSET).orElse(null);
        String extractedCursor = jsonObject.getValue(SearchResult.JsonFields.CURSOR).orElse(null);
        return ImmutableSearchResult.of(extractedItems, extractedNextPageOffset, extractedCursor);
    }

    @Override
    public JsonArray getItems() {
        return this.items;
    }

    @Override
    public Optional<Long> getNextPageOffset() {
        return Optional.ofNullable(this.nextPageOffset);
    }

    @Override
    public Optional<String> getCursor() {
        return Optional.ofNullable(this.cursor);
    }

    @Override
    public boolean hasNextPage() {
        return this.cursor != null || this.nextPageOffset != null && this.nextPageOffset != -1L;
    }

    @Override
    public int getSize() {
        return this.items.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Stream<JsonValue> stream() {
        return this.items.stream();
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return this.items.iterator();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder builder = JsonFactory.newObjectBuilder().set(SearchResult.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate).set(SearchResult.JsonFields.ITEMS, (Object)this.items, predicate);
        this.getNextPageOffset().ifPresent(offset -> builder.set(SearchResult.JsonFields.NEXT_PAGE_OFFSET, offset, predicate));
        this.getCursor().ifPresent(cursor -> builder.set(SearchResult.JsonFields.CURSOR, cursor, predicate));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSearchResult that = (ImmutableSearchResult)o;
        return Objects.equals(this.nextPageOffset, that.nextPageOffset) && Objects.equals(this.cursor, that.cursor) && Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageOffset, this.cursor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [items=" + this.items + ", nextPageOffset=" + this.nextPageOffset + ", cursor=" + this.cursor + "]";
    }
}

