/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.thingsearch.ImmutablePropertyFilter;
import org.eclipse.ditto.model.thingsearch.PropertySearchFilter;
import org.eclipse.ditto.model.thingsearch.SearchFilter;
import org.eclipse.ditto.model.thingsearch.SearchProperty;

@Immutable
final class ImmutableSearchProperty
implements SearchProperty {
    private final JsonPointer propertyPath;

    private ImmutableSearchProperty(JsonPointer thePropertyPath) {
        this.propertyPath = thePropertyPath;
    }

    public static ImmutableSearchProperty of(JsonPointer propertyPath) {
        ConditionChecker.checkNotNull((Object)propertyPath, (String)"property path");
        return new ImmutableSearchProperty(propertyPath);
    }

    @SafeVarargs
    private static <T> Collection<JsonValue> toCollection(Function<T, JsonValue> toJsonValueFunction, T value, T ... furtherValues) {
        ConditionChecker.checkNotNull(furtherValues, (String)"additional values");
        ArrayList<JsonValue> result = new ArrayList<JsonValue>(1 + furtherValues.length);
        result.add(toJsonValueFunction.apply(value));
        for (T furtherValue : furtherValues) {
            result.add(toJsonValueFunction.apply(furtherValue));
        }
        return result;
    }

    private static void checkStringValue(String value) {
        ConditionChecker.checkNotNull((Object)value, (String)"string value");
    }

    @Override
    public PropertySearchFilter exists() {
        return ImmutablePropertyFilter.of(SearchFilter.Type.EXISTS, (CharSequence)this.propertyPath, Collections.emptySet());
    }

    @Override
    public PropertySearchFilter eq(boolean value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.EQ, (CharSequence)this.propertyPath, JsonFactory.newValue((boolean)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter eq(int value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.EQ, (CharSequence)this.propertyPath, JsonFactory.newValue((int)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter eq(long value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.EQ, (CharSequence)this.propertyPath, JsonFactory.newValue((long)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter eq(double value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.EQ, (CharSequence)this.propertyPath, JsonFactory.newValue((double)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter eq(@Nullable String value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.EQ, (CharSequence)this.propertyPath, JsonFactory.newValue((String)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ne(boolean value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.NE, (CharSequence)this.propertyPath, JsonFactory.newValue((boolean)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ne(int value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.NE, (CharSequence)this.propertyPath, JsonFactory.newValue((int)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ne(long value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.NE, (CharSequence)this.propertyPath, JsonFactory.newValue((long)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ne(double value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.NE, (CharSequence)this.propertyPath, JsonFactory.newValue((double)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ne(@Nullable String value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.NE, (CharSequence)this.propertyPath, JsonFactory.newValue((String)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ge(boolean value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.GE, (CharSequence)this.propertyPath, JsonFactory.newValue((boolean)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ge(int value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.GE, (CharSequence)this.propertyPath, JsonFactory.newValue((int)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ge(long value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.GE, (CharSequence)this.propertyPath, JsonFactory.newValue((long)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ge(double value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.GE, (CharSequence)this.propertyPath, JsonFactory.newValue((double)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter ge(String value) {
        ImmutableSearchProperty.checkStringValue(value);
        return ImmutablePropertyFilter.of(SearchFilter.Type.GE, (CharSequence)this.propertyPath, JsonFactory.newValue((String)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter gt(boolean value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.GT, (CharSequence)this.propertyPath, JsonFactory.newValue((boolean)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter gt(int value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.GT, (CharSequence)this.propertyPath, JsonFactory.newValue((int)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter gt(long value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.GT, (CharSequence)this.propertyPath, JsonFactory.newValue((long)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter gt(double value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.GT, (CharSequence)this.propertyPath, JsonFactory.newValue((double)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter gt(String value) {
        ImmutableSearchProperty.checkStringValue(value);
        return ImmutablePropertyFilter.of(SearchFilter.Type.GT, (CharSequence)this.propertyPath, JsonFactory.newValue((String)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter le(boolean value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.LE, (CharSequence)this.propertyPath, JsonFactory.newValue((boolean)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter le(int value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.LE, (CharSequence)this.propertyPath, JsonFactory.newValue((int)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter le(long value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.LE, (CharSequence)this.propertyPath, JsonFactory.newValue((long)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter le(double value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.LE, (CharSequence)this.propertyPath, JsonFactory.newValue((double)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter le(String value) {
        ImmutableSearchProperty.checkStringValue(value);
        return ImmutablePropertyFilter.of(SearchFilter.Type.LE, (CharSequence)this.propertyPath, JsonFactory.newValue((String)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter lt(boolean value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.LT, (CharSequence)this.propertyPath, JsonFactory.newValue((boolean)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter lt(int value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.LT, (CharSequence)this.propertyPath, JsonFactory.newValue((int)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter lt(long value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.LT, (CharSequence)this.propertyPath, JsonFactory.newValue((long)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter lt(double value) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.LT, (CharSequence)this.propertyPath, JsonFactory.newValue((double)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter lt(String value) {
        ImmutableSearchProperty.checkStringValue(value);
        return ImmutablePropertyFilter.of(SearchFilter.Type.LT, (CharSequence)this.propertyPath, JsonFactory.newValue((String)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter like(String value) {
        ImmutableSearchProperty.checkStringValue(value);
        return ImmutablePropertyFilter.of(SearchFilter.Type.LIKE, (CharSequence)this.propertyPath, JsonFactory.newValue((String)value), new JsonValue[0]);
    }

    @Override
    public PropertySearchFilter in(boolean value, Boolean ... furtherValues) {
        return this.in(ImmutableSearchProperty.toCollection(JsonFactory::newValue, value, furtherValues));
    }

    @Override
    public PropertySearchFilter in(int value, Integer ... furtherValues) {
        return this.in(ImmutableSearchProperty.toCollection(JsonFactory::newValue, value, furtherValues));
    }

    @Override
    public PropertySearchFilter in(long value, Long ... furtherValues) {
        return this.in(ImmutableSearchProperty.toCollection(JsonFactory::newValue, value, furtherValues));
    }

    @Override
    public PropertySearchFilter in(double value, Double ... furtherValues) {
        return this.in(ImmutableSearchProperty.toCollection(JsonFactory::newValue, value, furtherValues));
    }

    @Override
    public PropertySearchFilter in(String value, String ... furtherValues) {
        ImmutableSearchProperty.checkStringValue(value);
        return this.in(ImmutableSearchProperty.toCollection(JsonFactory::newValue, value, furtherValues));
    }

    @Override
    public PropertySearchFilter in(Collection<JsonValue> values) {
        return ImmutablePropertyFilter.of(SearchFilter.Type.IN, (CharSequence)this.propertyPath, values);
    }

    @Override
    public JsonPointer getPath() {
        return this.propertyPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSearchProperty immutableSearchProperty = (ImmutableSearchProperty)o;
        return Objects.equals(this.propertyPath, immutableSearchProperty.propertyPath);
    }

    public int hashCode() {
        return Objects.hash(this.propertyPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [propertyPath=" + this.propertyPath + "]";
    }
}

