/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.thingsearch.PropertySearchFilter;
import org.eclipse.ditto.model.thingsearch.SearchFilter;

@Immutable
final class ImmutablePropertyFilter
implements PropertySearchFilter {
    private final SearchFilter.Type type;
    private final JsonPointer propertyPath;
    private final Collection<JsonValue> values;

    private ImmutablePropertyFilter(SearchFilter.Type type, CharSequence propertyPath, Collection<JsonValue> values) {
        this.type = (SearchFilter.Type)((Object)ConditionChecker.checkNotNull((Object)((Object)type), (String)"type"));
        this.propertyPath = JsonFactory.newPointer((CharSequence)((CharSequence)ConditionChecker.checkNotNull((Object)propertyPath, (String)"propertyPath")));
        this.values = Collections.unmodifiableList(new ArrayList<JsonValue>(values));
    }

    public static ImmutablePropertyFilter of(SearchFilter.Type type, CharSequence propertyPath, Collection<JsonValue> filterValues) {
        return new ImmutablePropertyFilter(type, propertyPath, (Collection)ConditionChecker.checkNotNull(filterValues, (String)"filter values"));
    }

    public static ImmutablePropertyFilter of(SearchFilter.Type type, CharSequence propertyPath, JsonValue filterValue, JsonValue ... furtherFilterValues) {
        ConditionChecker.checkNotNull((Object)filterValue, (String)"filter values");
        ConditionChecker.checkNotNull((Object)furtherFilterValues, (String)"further filter values");
        ArrayList<JsonValue> filterValues = new ArrayList<JsonValue>(1 + furtherFilterValues.length);
        filterValues.add(filterValue);
        Collections.addAll(filterValues, furtherFilterValues);
        return ImmutablePropertyFilter.of(type, propertyPath, filterValues);
    }

    @Override
    public SearchFilter.Type getType() {
        return this.type;
    }

    @Override
    public JsonPointer getPath() {
        return this.propertyPath;
    }

    @Override
    public Collection<JsonValue> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePropertyFilter that = (ImmutablePropertyFilter)o;
        return this.type == that.type && Objects.equals(this.propertyPath, that.propertyPath) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.propertyPath, this.values});
    }

    @Override
    public String toString() {
        return this.createFilterString();
    }

    private String createFilterString() {
        String delimiter = ",";
        String prefix = this.type.getName() + "(";
        String suffix = ")";
        StringJoiner stringJoiner = new StringJoiner(",", prefix, ")");
        stringJoiner.add(this.propertyPath.toString());
        this.values.stream().map(JsonValue::toString).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }
}

