/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.thingsearch.LimitOption;
import org.eclipse.ditto.model.thingsearch.OptionVisitor;

@Immutable
final class ImmutableLimitOption
implements LimitOption {
    static final int MAX_COUNT = 200;
    private final int offset;
    private final int count;

    private ImmutableLimitOption(int offset, int count) {
        this.offset = offset;
        this.count = count;
    }

    public static ImmutableLimitOption of(int offset, int count) {
        return new ImmutableLimitOption(offset, count);
    }

    @Override
    public void accept(OptionVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableLimitOption that = (ImmutableLimitOption)o;
        return this.offset == that.offset && this.count == that.count;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.count);
    }

    @Override
    public String toString() {
        return "limit(" + this.offset + "," + this.count + ")";
    }
}

