/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;
import org.eclipse.ditto.model.base.acks.FilteredAcknowledgementRequest;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.connectivity.Enforcement;
import org.eclipse.ditto.model.connectivity.HeaderMapping;
import org.eclipse.ditto.model.connectivity.PayloadMapping;
import org.eclipse.ditto.model.connectivity.ReplyTarget;

public interface Source
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public Set<String> getAddresses();

    public int getConsumerCount();

    public AuthorizationContext getAuthorizationContext();

    public int getIndex();

    public Optional<Integer> getQos();

    public Optional<Enforcement> getEnforcement();

    public Optional<FilteredAcknowledgementRequest> getAcknowledgementRequests();

    public Optional<HeaderMapping> getHeaderMapping();

    public PayloadMapping getPayloadMapping();

    public Optional<ReplyTarget> getReplyTarget();

    public boolean isReplyTargetEnabled();

    public Set<AcknowledgementLabel> getDeclaredAcknowledgementLabels();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.notHidden())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> ADDRESSES = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"addresses", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Integer> CONSUMER_COUNT = JsonFactory.newIntFieldDefinition((CharSequence)"consumerCount", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Integer> QOS = JsonFactory.newIntFieldDefinition((CharSequence)"qos", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> AUTHORIZATION_CONTEXT = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"authorizationContext", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> ENFORCEMENT = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"enforcement", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> ACKNOWLEDGEMENT_REQUESTS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"acknowledgementRequests", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> HEADER_MAPPING = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"headerMapping", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> PAYLOAD_MAPPING = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"payloadMapping", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> REPLY_TARGET = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"replyTarget", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Boolean> REPLY_TARGET_ENABLED = JsonFactory.newBooleanFieldDefinition((CharSequence)"replyTarget/enabled", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> DECLARED_ACKS = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"declaredAcks", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        JsonFields() {
            throw new AssertionError();
        }
    }
}

