/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.connectivity.MetricDirection;

public enum MetricType {
    CONSUMED("consumed", MetricDirection.INBOUND),
    DISPATCHED("dispatched", MetricDirection.OUTBOUND),
    FILTERED("filtered", MetricDirection.OUTBOUND),
    MAPPED("mapped", MetricDirection.INBOUND, MetricDirection.OUTBOUND),
    DROPPED("dropped", MetricDirection.INBOUND, MetricDirection.OUTBOUND),
    ENFORCED("enforced", MetricDirection.INBOUND),
    PUBLISHED("published", MetricDirection.OUTBOUND),
    ACKNOWLEDGED("acknowledged", MetricDirection.INBOUND, MetricDirection.OUTBOUND);

    private final String name;
    private final List<MetricDirection> possibleMetricDirections;

    private MetricType(String name, MetricDirection ... possibleMetricDirections) {
        this.name = name;
        this.possibleMetricDirections = Arrays.asList(possibleMetricDirections);
    }

    public String getName() {
        return this.name;
    }

    public boolean supportsDirection(MetricDirection direction) {
        return this.possibleMetricDirections.contains((Object)direction);
    }

    public static Optional<MetricType> forName(CharSequence name) {
        ConditionChecker.checkNotNull((Object)name, (String)"Name");
        return Arrays.stream(MetricType.values()).filter(c -> c.name.contentEquals(name)).findFirst();
    }

    public String toString() {
        return this.name;
    }
}

