/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:message.sending.failed")
@Immutable
public final class MessageSendingFailedException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:message.sending.failed";
    private static final HttpStatus DEFAULT_HTTP_STATUS = HttpStatus.SERVICE_UNAVAILABLE;
    private static final String MESSAGE_TEMPLATE = "Failed to send message: {0}";
    private static final String DEFAULT_MESSAGE = "Failed to send message.";
    private static final String DEFAULT_DESCRIPTION = "Sending the message to an external system failed, please check if your connection is configured properly and the target system is available and consuming messages.";
    private static final long serialVersionUID = 8762467293113632771L;

    private MessageSendingFailedException(DittoHeaders dittoHeaders, HttpStatus httpStatus, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, httpStatus, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static MessageSendingFailedException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (MessageSendingFailedException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static MessageSendingFailedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (MessageSendingFailedException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    static /* synthetic */ HttpStatus access$100() {
        return DEFAULT_HTTP_STATUS;
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<MessageSendingFailedException> {
        private HttpStatus httpStatus = MessageSendingFailedException.access$100();

        private Builder() {
            this.description(MessageSendingFailedException.DEFAULT_DESCRIPTION);
        }

        @Deprecated
        public Builder statusCode(HttpStatusCode statusCode) {
            return this.httpStatus(statusCode.getAsHttpStatus());
        }

        public Builder httpStatus(HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public Builder cause(@Nullable Throwable cause) {
            if (cause == null) {
                this.message(MessageSendingFailedException.DEFAULT_MESSAGE);
            } else {
                super.cause(cause);
                this.message(MessageFormat.format(MessageSendingFailedException.MESSAGE_TEMPLATE, cause.getMessage()));
            }
            return this;
        }

        protected MessageSendingFailedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new MessageSendingFailedException(dittoHeaders, this.httpStatus, message, description, cause, href);
        }
    }
}

