/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:message.mapping.failed")
@Immutable
public final class MessageMappingFailedException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:message.mapping.failed";
    private static final String MESSAGE_TEMPLATE = "The external message with content-type ''{0}'' could not be mapped.";
    private static final String DEFAULT_DESCRIPTION = "Check if you are sending the correct content-type/payload combination an that you have registered a mapper which transforms your payload to Ditto Protocol";
    private static final String CONTENT_TYPE_MISSING_DESCRIPTION = "Make sure you specify the 'Content-Type' when sending your message";
    private static final long serialVersionUID = -6312489434534126579L;

    private MessageMappingFailedException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(@Nullable String contentType) {
        return new Builder(contentType);
    }

    public static MessageMappingFailedException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (MessageMappingFailedException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static MessageMappingFailedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (MessageMappingFailedException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<MessageMappingFailedException> {
        private Builder() {
            this.description(MessageMappingFailedException.DEFAULT_DESCRIPTION);
        }

        private Builder(@Nullable String contentType) {
            this();
            boolean contentTypeAvailable = contentType != null && !contentType.isEmpty();
            this.message(MessageFormat.format(MessageMappingFailedException.MESSAGE_TEMPLATE, contentTypeAvailable ? contentType : "<unspecified>"));
            if (!contentTypeAvailable) {
                this.description(MessageMappingFailedException.CONTENT_TYPE_MISSING_DESCRIPTION);
            }
        }

        protected MessageMappingFailedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new MessageMappingFailedException(dittoHeaders, message, description, cause, href);
        }
    }
}

