/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:message.mapper.config.invalid")
@Immutable
public final class MessageMapperConfigurationInvalidException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:message.mapper.config.invalid";
    private static final String MESSAGE_TEMPLATE = "The message mapper was not configured correctly as property ''{0}'' was missing from the mapper's configuration.";
    private static final String DEFAULT_DESCRIPTION = "Make sure to add the missing property to the mapper's configuration.";
    private static final long serialVersionUID = -2538489434734124572L;

    private MessageMapperConfigurationInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String missingConfigurationProperty) {
        return new Builder(missingConfigurationProperty);
    }

    public static MessageMapperConfigurationInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (MessageMapperConfigurationInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static MessageMapperConfigurationInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (MessageMapperConfigurationInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<MessageMapperConfigurationInvalidException> {
        private Builder() {
            this.description(MessageMapperConfigurationInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(String missingConfigurationProperty) {
            this();
            this.message(MessageFormat.format(MessageMapperConfigurationInvalidException.MESSAGE_TEMPLATE, missingConfigurationProperty));
        }

        protected MessageMapperConfigurationInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new MessageMapperConfigurationInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

