/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:message.mapper.config.failed")
@Immutable
public final class MessageMapperConfigurationFailedException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:message.mapper.config.failed";
    private static final String MESSAGE_TEMPLATE = "The message mapper configuration failed due to: {0}";
    private static final String DEFAULT_DESCRIPTION = "Check the configuration options of your mapper for errors.";
    private static final long serialVersionUID = 3108439347153942427L;

    private MessageMapperConfigurationFailedException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String errorMessage) {
        return new Builder(errorMessage);
    }

    public static MessageMapperConfigurationFailedException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (MessageMapperConfigurationFailedException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static MessageMapperConfigurationFailedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (MessageMapperConfigurationFailedException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<MessageMapperConfigurationFailedException> {
        private Builder() {
            this.description(MessageMapperConfigurationFailedException.DEFAULT_DESCRIPTION);
        }

        private Builder(String errorMessage) {
            this();
            this.message(MessageFormat.format(MessageMapperConfigurationFailedException.MESSAGE_TEMPLATE, errorMessage));
        }

        protected MessageMapperConfigurationFailedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new MessageMapperConfigurationFailedException(dittoHeaders, message, description, cause, href);
        }
    }
}

