/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;

@Immutable
public interface MappingContext
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public String getMappingEngine();

    @Deprecated
    default public Map<String, String> getOptions() {
        return this.getOptionsAsJson().stream().collect(Collectors.toMap(JsonField::getKeyName, field -> field.getValue().formatAsString()));
    }

    public JsonObject getOptionsAsJson();

    public Map<String, String> getIncomingConditions();

    public Map<String, String> getOutgoingConditions();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.notHidden())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<String> MAPPING_ENGINE = JsonFactory.newStringFieldDefinition((CharSequence)"mappingEngine", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> OPTIONS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"options", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> INCOMING_CONDITIONS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"incomingConditions", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> OUTGOING_CONDITIONS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"outgoingConditions", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

