/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationContextType;
import org.eclipse.ditto.model.base.auth.AuthorizationModelFactory;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.auth.DittoAuthorizationContextType;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.ConnectivityModelFactory;
import org.eclipse.ditto.model.connectivity.FilteredTopic;
import org.eclipse.ditto.model.connectivity.FilteredTopicBuilder;
import org.eclipse.ditto.model.connectivity.HeaderMapping;
import org.eclipse.ditto.model.connectivity.ImmutableHeaderMapping;
import org.eclipse.ditto.model.connectivity.ImmutablePayloadMapping;
import org.eclipse.ditto.model.connectivity.PayloadMapping;
import org.eclipse.ditto.model.connectivity.Target;
import org.eclipse.ditto.model.connectivity.TargetBuilder;
import org.eclipse.ditto.model.connectivity.Topic;

@Immutable
final class ImmutableTarget
implements Target {
    static final HeaderMapping DEFAULT_HEADER_MAPPING = ConnectivityModelFactory.newHeaderMapping(JsonObject.newBuilder().set((CharSequence)"correlation-id", "{{header:correlation-id}}").set((CharSequence)"reply-to", "{{header:reply-to}}").build());
    private final String address;
    private final Set<FilteredTopic> topics;
    @Nullable
    private final Integer qos;
    private final AuthorizationContext authorizationContext;
    private final String originalAddress;
    @Nullable
    private final AcknowledgementLabel issuedAcknowledgementLabel;
    private final HeaderMapping headerMapping;
    private final PayloadMapping payloadMapping;

    private ImmutableTarget(Builder builder) {
        this.address = (String)ConditionChecker.checkNotNull((Object)builder.address, (String)"address");
        this.originalAddress = (String)ConditionChecker.checkNotNull((Object)builder.originalAddress, (String)"originalAddress");
        this.topics = Collections.unmodifiableSet(new HashSet(builder.topics == null ? Collections.emptySet() : builder.topics));
        this.qos = builder.qos;
        this.authorizationContext = (AuthorizationContext)ConditionChecker.checkNotNull((Object)builder.authorizationContext, (String)"authorizationContext");
        this.issuedAcknowledgementLabel = builder.issuedAcknowledgementLabel;
        this.headerMapping = builder.headerMapping;
        this.payloadMapping = builder.payloadMapping;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getOriginalAddress() {
        return this.originalAddress;
    }

    @Override
    public Target withAddress(String newAddress) {
        return new Builder(this).address(newAddress).build();
    }

    @Override
    public Set<FilteredTopic> getTopics() {
        return this.topics;
    }

    @Override
    public Optional<Integer> getQos() {
        return Optional.ofNullable(this.qos);
    }

    @Override
    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationContext;
    }

    @Override
    public Optional<AcknowledgementLabel> getIssuedAcknowledgementLabel() {
        return Optional.ofNullable(this.issuedAcknowledgementLabel);
    }

    @Override
    public Optional<HeaderMapping> getHeaderMapping() {
        return Optional.of(this.headerMapping);
    }

    @Override
    public PayloadMapping getPayloadMapping() {
        return this.payloadMapping;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(Target.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        jsonObjectBuilder.set(Target.JsonFields.ADDRESS, (Object)this.address, predicate);
        jsonObjectBuilder.set(Target.JsonFields.TOPICS, (Object)((JsonArray)this.topics.stream().map(FilteredTopic::toString).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray())), predicate.and(Objects::nonNull));
        if (this.qos != null) {
            jsonObjectBuilder.set(Target.JsonFields.QOS, (Object)this.qos, predicate);
        }
        if (!this.authorizationContext.isEmpty()) {
            jsonObjectBuilder.set(Target.JsonFields.AUTHORIZATION_CONTEXT, (Object)((JsonArray)this.authorizationContext.stream().map(AuthorizationSubject::getId).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray())), predicate);
        }
        if (this.issuedAcknowledgementLabel != null) {
            jsonObjectBuilder.set(Target.JsonFields.ISSUED_ACKNOWLEDGEMENT_LABEL, (Object)this.issuedAcknowledgementLabel.toString(), predicate);
        }
        jsonObjectBuilder.set(Target.JsonFields.HEADER_MAPPING, (Object)((JsonObject)this.headerMapping.toJson(schemaVersion, thePredicate)), predicate);
        if (!this.payloadMapping.isEmpty()) {
            jsonObjectBuilder.set(Target.JsonFields.PAYLOAD_MAPPING, (Object)((JsonArray)this.payloadMapping.toJson()), predicate);
        }
        return jsonObjectBuilder.build();
    }

    public static Target fromJson(JsonObject jsonObject) {
        Set<FilteredTopic> readTopics = jsonObject.getValue(Target.JsonFields.TOPICS).map(array -> array.stream().map(JsonValue::asString).map(ConnectivityModelFactory::newFilteredTopic).collect(Collectors.toSet())).orElse(Collections.emptySet());
        JsonArray authContext = jsonObject.getValue(Target.JsonFields.AUTHORIZATION_CONTEXT).orElseGet(() -> JsonArray.newBuilder().build());
        List authorizationSubjects = authContext.stream().filter(JsonValue::isString).map(JsonValue::asString).map(AuthorizationSubject::newInstance).collect(Collectors.toList());
        AuthorizationContext readAuthorizationContext = AuthorizationModelFactory.newAuthContext((AuthorizationContextType)DittoAuthorizationContextType.PRE_AUTHENTICATED_CONNECTION, authorizationSubjects);
        AcknowledgementLabel readIssuedAcknowledgementLabel = jsonObject.getValue(Target.JsonFields.ISSUED_ACKNOWLEDGEMENT_LABEL).map(AcknowledgementLabel::of).orElse(null);
        HeaderMapping readHeaderMapping = jsonObject.getValue(Target.JsonFields.HEADER_MAPPING).map(ImmutableHeaderMapping::fromJson).orElse(null);
        PayloadMapping readMapping = jsonObject.getValue(Target.JsonFields.PAYLOAD_MAPPING).map(ImmutablePayloadMapping::fromJson).orElse(ConnectivityModelFactory.emptyPayloadMapping());
        return new Builder().address((String)jsonObject.getValueOrThrow(Target.JsonFields.ADDRESS)).topics(readTopics).qos(jsonObject.getValue(Target.JsonFields.QOS).orElse(null)).authorizationContext(readAuthorizationContext).issuedAcknowledgementLabel(readIssuedAcknowledgementLabel).headerMapping(readHeaderMapping).payloadMapping(readMapping).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTarget that = (ImmutableTarget)o;
        return this.address.equals(that.address) && this.topics.equals(that.topics) && Objects.equals(this.qos, that.qos) && this.authorizationContext.equals(that.authorizationContext) && this.originalAddress.equals(that.originalAddress) && Objects.equals(this.issuedAcknowledgementLabel, that.issuedAcknowledgementLabel) && Objects.equals(this.headerMapping, that.headerMapping) && this.payloadMapping.equals(that.payloadMapping);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.topics, this.qos, this.authorizationContext, this.originalAddress, this.issuedAcknowledgementLabel, this.headerMapping, this.payloadMapping);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [address=" + this.address + ", topics=" + this.topics + ", qos=" + this.qos + ", authorizationContext=" + this.authorizationContext + ", originalAddress=" + this.originalAddress + ", issuedAcknowledgementLabel=" + this.issuedAcknowledgementLabel + ", headerMapping=" + this.headerMapping + ", payloadMapping=" + this.payloadMapping + "]";
    }

    @NotThreadSafe
    static final class Builder
    implements TargetBuilder {
        private PayloadMapping payloadMapping = ConnectivityModelFactory.emptyPayloadMapping();
        @Nullable
        private String address;
        @Nullable
        private String originalAddress;
        @Nullable
        private Set<FilteredTopic> topics;
        @Nullable
        private Integer qos;
        @Nullable
        private AuthorizationContext authorizationContext;
        @Nullable
        private AcknowledgementLabel issuedAcknowledgementLabel;
        private HeaderMapping headerMapping = ConnectivityModelFactory.emptyHeaderMapping();

        Builder() {
        }

        Builder(Target target) {
            this.address(target.getAddress()).authorizationContext(target.getAuthorizationContext()).topics(target.getTopics()).headerMapping(target.getHeaderMapping().orElse(null)).qos(target.getQos().orElse(null)).issuedAcknowledgementLabel(target.getIssuedAcknowledgementLabel().orElse(null)).payloadMapping(target.getPayloadMapping());
        }

        @Override
        public TargetBuilder address(String address) {
            this.address = address;
            if (this.originalAddress == null) {
                this.originalAddress = address;
            }
            return this;
        }

        @Override
        public TargetBuilder originalAddress(String originalAddress) {
            this.originalAddress = originalAddress;
            return this;
        }

        @Override
        public TargetBuilder qos(@Nullable Integer qos) {
            this.qos = qos;
            return this;
        }

        @Override
        public TargetBuilder authorizationContext(AuthorizationContext authorizationContext) {
            this.authorizationContext = authorizationContext;
            return this;
        }

        @Override
        public TargetBuilder topics(Set<FilteredTopic> topics) {
            this.topics = topics;
            return this;
        }

        @Override
        public TargetBuilder topics(FilteredTopic requiredTopic, FilteredTopic ... additionalTopics) {
            HashSet<FilteredTopic> theTopics = new HashSet<FilteredTopic>(1 + additionalTopics.length);
            theTopics.add(requiredTopic);
            Collections.addAll(theTopics, additionalTopics);
            return this.topics(theTopics);
        }

        @Override
        public TargetBuilder topics(Topic requiredTopic, Topic ... additionalTopics) {
            EnumSet<Topic[]> theTopics = EnumSet.of(requiredTopic, additionalTopics);
            Set<FilteredTopic> filteredTopics = theTopics.stream().map(ConnectivityModelFactory::newFilteredTopicBuilder).map(FilteredTopicBuilder::build).collect(Collectors.toSet());
            return this.topics(filteredTopics);
        }

        @Override
        public TargetBuilder issuedAcknowledgementLabel(@Nullable AcknowledgementLabel acknowledgementLabel) {
            this.issuedAcknowledgementLabel = acknowledgementLabel;
            return this;
        }

        @Override
        public TargetBuilder headerMapping(@Nullable HeaderMapping headerMapping) {
            this.headerMapping = headerMapping == null ? ConnectivityModelFactory.emptyHeaderMapping() : headerMapping;
            return this;
        }

        @Override
        public TargetBuilder payloadMapping(PayloadMapping payloadMapping) {
            this.payloadMapping = payloadMapping;
            return this;
        }

        @Override
        public Target build() {
            ConditionChecker.checkNotNull((Object)this.address, (String)"address");
            ConditionChecker.checkNotNull(this.topics, (String)"topics");
            ConditionChecker.checkNotNull((Object)this.authorizationContext, (String)"authorizationContext");
            ConditionChecker.checkNotNull((Object)this.originalAddress, (String)"originalAddress");
            return new ImmutableTarget(this);
        }
    }
}

