/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.ConnectivityStatus;
import org.eclipse.ditto.model.connectivity.ResourceStatus;

@Immutable
final class ImmutableResourceStatus
implements ResourceStatus {
    private final ResourceStatus.ResourceType type;
    private final String client;
    private final ConnectivityStatus status;
    @Nullable
    private final String address;
    @Nullable
    private final String statusDetails;
    @Nullable
    private final Instant inStateSince;

    private ImmutableResourceStatus(ResourceStatus.ResourceType type, String client, ConnectivityStatus status, @Nullable String address, @Nullable String statusDetails, @Nullable Instant inStateSince) {
        this.type = type;
        this.client = client;
        this.address = address;
        this.status = status;
        this.statusDetails = statusDetails;
        this.inStateSince = inStateSince;
    }

    public static ImmutableResourceStatus of(ResourceStatus.ResourceType type, String client, ConnectivityStatus status, @Nullable String address, @Nullable String statusDetails, @Nullable Instant inStateSince) {
        return new ImmutableResourceStatus(type, client, status, address, statusDetails, inStateSince);
    }

    public static ImmutableResourceStatus of(ResourceStatus.ResourceType type, String client, ConnectivityStatus status, @Nullable String address, @Nullable String statusDetails) {
        return new ImmutableResourceStatus(type, client, status, address, statusDetails, null);
    }

    @Override
    public ResourceStatus.ResourceType getResourceType() {
        return this.type;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    @Override
    public ConnectivityStatus getStatus() {
        return this.status;
    }

    @Override
    public Optional<String> getStatusDetails() {
        return Optional.ofNullable(this.statusDetails);
    }

    @Override
    public Optional<Instant> getInStateSince() {
        return Optional.ofNullable(this.inStateSince);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(ResourceStatus.JsonFields.TYPE, (Object)this.type.getName(), predicate);
        jsonObjectBuilder.set(ResourceStatus.JsonFields.CLIENT, (Object)this.client, predicate);
        if (this.address != null) {
            jsonObjectBuilder.set(ResourceStatus.JsonFields.ADDRESS, (Object)this.address, predicate);
        }
        jsonObjectBuilder.set(ResourceStatus.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        jsonObjectBuilder.set(ResourceStatus.JsonFields.STATUS, (Object)this.status.getName(), predicate);
        if (this.statusDetails != null) {
            jsonObjectBuilder.set(ResourceStatus.JsonFields.STATUS_DETAILS, (Object)this.statusDetails, predicate);
        }
        if (this.inStateSince != null) {
            jsonObjectBuilder.set(ResourceStatus.JsonFields.IN_STATE_SINCE, (Object)this.inStateSince.toString(), predicate);
        }
        return jsonObjectBuilder.build();
    }

    public static ResourceStatus fromJson(JsonObject jsonObject) {
        ResourceStatus.ResourceType readType = ResourceStatus.ResourceType.forName((CharSequence)jsonObject.getValueOrThrow(ResourceStatus.JsonFields.TYPE)).orElse(ResourceStatus.ResourceType.UNKNOWN);
        String readClient = (String)jsonObject.getValueOrThrow(ResourceStatus.JsonFields.CLIENT);
        ConnectivityStatus readConnectionStatus = ConnectivityStatus.forName((CharSequence)jsonObject.getValueOrThrow(ResourceStatus.JsonFields.STATUS)).orElse(ConnectivityStatus.UNKNOWN);
        String readAddress = jsonObject.getValue(ResourceStatus.JsonFields.ADDRESS).orElse(null);
        String readConnectionStatusDetails = jsonObject.getValue(ResourceStatus.JsonFields.STATUS_DETAILS).orElse(null);
        Instant readInStateSince = jsonObject.getValue(ResourceStatus.JsonFields.IN_STATE_SINCE).map(Instant::parse).orElse(null);
        return ImmutableResourceStatus.of(readType, readClient, readConnectionStatus, readAddress, readConnectionStatusDetails, readInStateSince);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableResourceStatus)) {
            return false;
        }
        ImmutableResourceStatus that = (ImmutableResourceStatus)o;
        return this.type == that.type && Objects.equals(this.client, that.client) && Objects.equals(this.status, that.status) && Objects.equals(this.address, that.address) && Objects.equals(this.inStateSince, that.inStateSince) && Objects.equals(this.statusDetails, that.statusDetails);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.client, this.status, this.address, this.statusDetails, this.inStateSince);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [type=" + this.type + ", client=" + this.client + ", status=" + this.status + ", address=" + this.address + ", statusDetails=" + this.statusDetails + ", inStateSince=" + this.inStateSince + "]";
    }
}

