/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.connectivity.PayloadMapping;

@Immutable
final class ImmutablePayloadMapping
implements PayloadMapping {
    private final List<String> mappings;

    private ImmutablePayloadMapping(List<String> mappings) {
        ConditionChecker.checkNotNull(mappings, (String)"mappings");
        this.mappings = Collections.unmodifiableList(new ArrayList<String>(mappings));
    }

    static PayloadMapping empty() {
        return new ImmutablePayloadMapping(Collections.emptyList());
    }

    static PayloadMapping from(List<String> mappings) {
        return new ImmutablePayloadMapping(mappings);
    }

    @Override
    public List<String> getMappings() {
        return this.mappings;
    }

    @Override
    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    public JsonArray toJson() {
        return JsonArray.of(this.mappings);
    }

    public static PayloadMapping fromJson(JsonArray jsonArray) {
        return ImmutablePayloadMapping.from(jsonArray.stream().filter(JsonValue::isString).map(JsonValue::asString).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePayloadMapping that = (ImmutablePayloadMapping)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [mappings=" + this.mappings + "]";
    }
}

