/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.MappingContext;
import org.eclipse.ditto.model.connectivity.MappingContextBuilder;

@Immutable
final class ImmutableMappingContext
implements MappingContext {
    private final String mappingEngine;
    private final JsonObject options;
    private final Map<String, String> incomingConditions;
    private final Map<String, String> outgoingConditions;

    private ImmutableMappingContext(Builder builder) {
        this.mappingEngine = builder.mappingEngine;
        this.options = builder.options;
        this.incomingConditions = Collections.unmodifiableMap(new HashMap(builder.incomingConditions == null ? Collections.emptyMap() : builder.incomingConditions));
        this.outgoingConditions = Collections.unmodifiableMap(new HashMap(builder.outgoingConditions == null ? Collections.emptyMap() : builder.outgoingConditions));
    }

    static ImmutableMappingContext of(String mappingEngine, JsonObject options) {
        ConditionChecker.checkNotNull((Object)mappingEngine, (String)"mappingEngine");
        ConditionChecker.checkNotNull((Object)options, (String)"options");
        return (ImmutableMappingContext)new Builder(mappingEngine, options).build();
    }

    public static MappingContext fromJson(JsonObject jsonObject) {
        String mappingEngine = (String)jsonObject.getValueOrThrow(MappingContext.JsonFields.MAPPING_ENGINE);
        JsonObject options = (JsonObject)jsonObject.getValueOrThrow(MappingContext.JsonFields.OPTIONS);
        Builder builder = new Builder(mappingEngine, options);
        builder.incomingConditions(jsonObject.getValue(MappingContext.JsonFields.INCOMING_CONDITIONS).orElse(JsonObject.empty()).stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().isString() ? e.getValue().asString() : e.getValue().toString())));
        builder.outgoingConditions(jsonObject.getValue(MappingContext.JsonFields.OUTGOING_CONDITIONS).orElse(JsonObject.empty()).stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().isString() ? e.getValue().asString() : e.getValue().toString())));
        return builder.build();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(MappingContext.JsonFields.MAPPING_ENGINE, (Object)this.mappingEngine, predicate);
        jsonObjectBuilder.set(MappingContext.JsonFields.OPTIONS, (Object)this.options, predicate);
        if (!this.incomingConditions.isEmpty()) {
            jsonObjectBuilder.set(MappingContext.JsonFields.INCOMING_CONDITIONS, (Object)((JsonObject)this.incomingConditions.entrySet().stream().map(e -> JsonField.newInstance((CharSequence)((CharSequence)e.getKey()), (JsonValue)JsonValue.of((String)((String)e.getValue())))).collect(JsonCollectors.fieldsToObject())), predicate);
        }
        if (!this.outgoingConditions.isEmpty()) {
            jsonObjectBuilder.set(MappingContext.JsonFields.OUTGOING_CONDITIONS, (Object)((JsonObject)this.outgoingConditions.entrySet().stream().map(e -> JsonField.newInstance((CharSequence)((CharSequence)e.getKey()), (JsonValue)JsonValue.of((String)((String)e.getValue())))).collect(JsonCollectors.fieldsToObject())), predicate);
        }
        return jsonObjectBuilder.build();
    }

    @Override
    public String getMappingEngine() {
        return this.mappingEngine;
    }

    @Override
    public JsonObject getOptionsAsJson() {
        return this.options;
    }

    @Override
    public Map<String, String> getIncomingConditions() {
        return this.incomingConditions;
    }

    @Override
    public Map<String, String> getOutgoingConditions() {
        return this.outgoingConditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableMappingContext)) {
            return false;
        }
        ImmutableMappingContext that = (ImmutableMappingContext)o;
        return Objects.equals(this.mappingEngine, that.mappingEngine) && Objects.equals(this.options, that.options) && Objects.equals(this.incomingConditions, that.incomingConditions) && Objects.equals(this.outgoingConditions, that.outgoingConditions);
    }

    public int hashCode() {
        return Objects.hash(this.mappingEngine, this.options, this.incomingConditions, this.outgoingConditions);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [mappingEngine=" + this.mappingEngine + ", options=" + this.options + ", incomingConditions=" + this.incomingConditions + ", outgoingConditions=" + this.outgoingConditions + "]";
    }

    @NotThreadSafe
    static final class Builder
    implements MappingContextBuilder {
        private String mappingEngine;
        private JsonObject options;
        @Nullable
        private Map<String, String> incomingConditions;
        @Nullable
        private Map<String, String> outgoingConditions;

        Builder(String mappingEngine, JsonObject options) {
            this.mappingEngine = mappingEngine;
            this.options = options;
        }

        @Override
        public MappingContextBuilder mappingEngine(String mappingEngine) {
            this.mappingEngine = mappingEngine;
            return this;
        }

        @Override
        public MappingContextBuilder options(JsonObject options) {
            this.options = options;
            return this;
        }

        @Override
        public MappingContextBuilder incomingConditions(Map<String, String> incomingConditions) {
            this.incomingConditions = incomingConditions;
            return this;
        }

        @Override
        public MappingContextBuilder outgoingConditions(Map<String, String> outgoingConditions) {
            this.outgoingConditions = outgoingConditions;
            return this;
        }

        @Override
        public MappingContext build() {
            ConditionChecker.checkNotNull((Object)this.mappingEngine, (String)"mappingEngine");
            ConditionChecker.checkNotNull((Object)this.options, (String)"options");
            return new ImmutableMappingContext(this);
        }
    }
}

