/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.HeaderMapping;

@Immutable
final class ImmutableHeaderMapping
implements HeaderMapping {
    private final Map<String, String> mapping;

    ImmutableHeaderMapping(Map<String, String> mapping) {
        this.mapping = Collections.unmodifiableMap(new HashMap<String, String>(mapping));
    }

    @Override
    public Map<String, String> getMapping() {
        return this.mapping;
    }

    static HeaderMapping fromJson(JsonObject jsonObject) {
        return new ImmutableHeaderMapping(jsonObject.stream().filter(f -> f.getValue().isString()).collect(Collectors.toMap(JsonField::getKeyName, jsonField -> jsonField.getValue().asString())));
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        List fields = this.mapping.entrySet().stream().map(e -> JsonFactory.newField((JsonKey)JsonFactory.newKey((CharSequence)((CharSequence)e.getKey())), (JsonValue)JsonFactory.newValue((String)((String)e.getValue())))).collect(Collectors.toList());
        return JsonFactory.newObjectBuilder(fields).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableHeaderMapping that = (ImmutableHeaderMapping)o;
        return Objects.equals(this.mapping, that.mapping);
    }

    public int hashCode() {
        return Objects.hash(this.mapping);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [mapping=" + this.mapping + "]";
    }
}

