/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.connectivity.FilteredTopic;
import org.eclipse.ditto.model.connectivity.FilteredTopicBuilder;
import org.eclipse.ditto.model.connectivity.Topic;
import org.eclipse.ditto.model.connectivity.TopicParseException;
import org.eclipse.ditto.model.things.ThingFieldSelector;

@Immutable
final class ImmutableFilteredTopic
implements FilteredTopic {
    private static final String QUERY_DELIMITER = "?";
    private static final String QUERY_ARG_DELIMITER = "&";
    private static final String QUERY_ARG_VALUE_DELIMITER = "=";
    private static final String FILTER_ARG = "filter";
    private static final String NAMESPACES_ARG = "namespaces";
    private static final String EXTRA_FIELDS_ARG = "extraFields";
    private final Topic topic;
    private final List<String> namespaces;
    @Nullable
    private final String filterString;
    @Nullable
    private final ThingFieldSelector extraFields;

    private ImmutableFilteredTopic(ImmutableFilteredTopicBuilder builder) {
        this.topic = builder.topic;
        Collection namespacesFromBuilder = builder.namespaces;
        this.namespaces = null != namespacesFromBuilder ? Collections.unmodifiableList(new ArrayList(namespacesFromBuilder)) : Collections.emptyList();
        this.filterString = Objects.toString(builder.filter, null);
        this.extraFields = builder.extraFields;
    }

    public static ImmutableFilteredTopicBuilder getBuilder(Topic topic) {
        return new ImmutableFilteredTopicBuilder(topic);
    }

    public static ImmutableFilteredTopic fromString(String filteredTopicString) {
        ConditionChecker.checkNotNull((Object)filteredTopicString, (String)"filteredTopicString");
        FilteredTopicStringParser parser = new FilteredTopicStringParser(filteredTopicString);
        return parser.parse();
    }

    @Override
    public Topic getTopic() {
        return this.topic;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filterString);
    }

    @Override
    public Optional<JsonFieldSelector> getExtraFields() {
        return Optional.ofNullable(this.extraFields);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        return ImmutableFilteredTopic.join(QUERY_DELIMITER, this.topic.getName(), this.getQueryParametersAsString());
    }

    private String getQueryParametersAsString() {
        return ImmutableFilteredTopic.join(QUERY_ARG_DELIMITER, ImmutableFilteredTopic.getQueryParameterString(NAMESPACES_ARG, String.join((CharSequence)",", this.namespaces)), ImmutableFilteredTopic.getQueryParameterString(FILTER_ARG, this.filterString), ImmutableFilteredTopic.getQueryParameterString(EXTRA_FIELDS_ARG, this.extraFields));
    }

    private static String getQueryParameterString(String parameterName, @Nullable Object parameterValue) {
        String parameterValueAsString;
        if (null != parameterValue && !(parameterValueAsString = parameterValue.toString()).isEmpty()) {
            return parameterName + QUERY_ARG_VALUE_DELIMITER + parameterValueAsString;
        }
        return "";
    }

    private static String join(String delimiter, String ... elements) {
        StringBuilder stringBuilder = new StringBuilder();
        String currentDelimiter = "";
        for (String element : elements) {
            if (null == element || element.isEmpty()) continue;
            stringBuilder.append(currentDelimiter).append(element);
            currentDelimiter = delimiter;
        }
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFilteredTopic that = (ImmutableFilteredTopic)o;
        return this.topic == that.topic && this.namespaces.equals(that.namespaces) && Objects.equals(this.filterString, that.filterString) && Objects.equals(this.extraFields, that.extraFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topic, this.namespaces, this.filterString, this.extraFields});
    }

    @Immutable
    private static final class FilteredTopicStringParser {
        private final String filteredTopicString;

        private FilteredTopicStringParser(String filteredTopicString) {
            this.filteredTopicString = filteredTopicString;
        }

        ImmutableFilteredTopic parse() {
            String topicName = this.filteredTopicString;
            String queryParamsString = null;
            if (this.filteredTopicString.contains(ImmutableFilteredTopic.QUERY_DELIMITER)) {
                String[] splitString = this.filteredTopicString.split("\\?", 2);
                topicName = splitString[0];
                queryParamsString = splitString[1];
            }
            Map<String, String> queryParameters = FilteredTopicStringParser.parseQueryParameters(queryParamsString);
            return ((ImmutableFilteredTopicBuilder)ImmutableFilteredTopic.getBuilder(this.parseTopic(topicName)).withNamespaces((Collection)FilteredTopicStringParser.parseNamespaces(queryParameters.get(ImmutableFilteredTopic.NAMESPACES_ARG)))).withFilter(queryParameters.get(ImmutableFilteredTopic.FILTER_ARG)).withExtraFields(FilteredTopicStringParser.parseExtraFields(queryParameters.get(ImmutableFilteredTopic.EXTRA_FIELDS_ARG))).build();
        }

        private Topic parseTopic(String topicName) {
            return Topic.forName(topicName).orElseThrow(() -> (TopicParseException)TopicParseException.newBuilder(this.filteredTopicString, "Unknown topic: " + topicName).build());
        }

        private static Map<String, String> parseQueryParameters(@Nullable String queryParamsString) {
            if (null == queryParamsString || queryParamsString.isEmpty()) {
                return Collections.emptyMap();
            }
            return Arrays.stream(queryParamsString.split(ImmutableFilteredTopic.QUERY_ARG_DELIMITER)).map(paramString -> paramString.split(ImmutableFilteredTopic.QUERY_ARG_VALUE_DELIMITER, 2)).filter(queryParamPair -> 2 == ((String[])queryParamPair).length).collect(Collectors.toMap(queryParamPair -> FilteredTopicStringParser.urlDecode(queryParamPair[0]), av -> FilteredTopicStringParser.urlDecode(av[1])));
        }

        private static String urlDecode(String value) {
            try {
                return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                return URLDecoder.decode(value);
            }
        }

        private static Collection<String> parseNamespaces(@Nullable String namespacesString) {
            if (null != namespacesString && !namespacesString.isEmpty()) {
                return Arrays.asList(namespacesString.split(","));
            }
            return Collections.emptyList();
        }

        @Nullable
        private static ThingFieldSelector parseExtraFields(@Nullable String extraFieldsString) {
            if (null != extraFieldsString && !extraFieldsString.isEmpty()) {
                return ThingFieldSelector.fromString((String)extraFieldsString);
            }
            return null;
        }
    }

    @NotThreadSafe
    static final class ImmutableFilteredTopicBuilder
    implements FilteredTopicBuilder {
        private final Topic topic;
        @Nullable
        private Collection<String> namespaces;
        @Nullable
        private CharSequence filter;
        @Nullable
        private ThingFieldSelector extraFields;

        private ImmutableFilteredTopicBuilder(Topic topic) {
            this.topic = (Topic)((Object)ConditionChecker.checkNotNull((Object)((Object)topic), (String)"topic"));
            this.namespaces = null;
            this.filter = null;
            this.extraFields = null;
        }

        @Override
        public ImmutableFilteredTopicBuilder withNamespaces(@Nullable Collection<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        @Override
        public ImmutableFilteredTopicBuilder withFilter(@Nullable CharSequence filter) {
            if (this.topic != Topic.POLICY_ANNOUNCEMENTS) {
                this.filter = filter;
            }
            return this;
        }

        @Override
        public ImmutableFilteredTopicBuilder withExtraFields(@Nullable ThingFieldSelector extraFields) {
            if (this.topic != Topic.POLICY_ANNOUNCEMENTS) {
                this.extraFields = extraFields;
            }
            return this;
        }

        @Override
        public ImmutableFilteredTopic build() {
            return new ImmutableFilteredTopic(this);
        }
    }
}

