/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.Enforcement;

@Immutable
final class ImmutableEnforcement
implements Enforcement {
    private final String input;
    private final Set<String> filters;

    private ImmutableEnforcement(String input, Set<String> filters) {
        this.input = input;
        this.filters = Collections.unmodifiableSet(new HashSet<String>(filters));
    }

    static ImmutableEnforcement of(String input, Set<String> filters) {
        return new ImmutableEnforcement(input, filters);
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public Set<String> getFilters() {
        return this.filters;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(Enforcement.JsonFields.INPUT, (Object)this.input, predicate);
        jsonObjectBuilder.set(Enforcement.JsonFields.FILTERS, (Object)((JsonArray)this.filters.stream().map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray())), predicate.and(Objects::nonNull));
        return jsonObjectBuilder.build();
    }

    public static Enforcement fromJson(JsonObject jsonObject) {
        Set<String> readFilters = jsonObject.getValue(Enforcement.JsonFields.FILTERS).map(array -> array.stream().map(JsonValue::asString).collect(Collectors.toSet())).orElse(Collections.emptySet());
        String readInput = (String)jsonObject.getValueOrThrow(Enforcement.JsonFields.INPUT);
        return new ImmutableEnforcement(readInput, readFilters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableEnforcement that = (ImmutableEnforcement)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.filters);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [input=" + this.input + ", filters=" + this.filters + "]";
    }
}

