/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.JsonValueContainer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.Connection;
import org.eclipse.ditto.model.connectivity.ConnectionBuilder;
import org.eclipse.ditto.model.connectivity.ConnectionConfigurationInvalidException;
import org.eclipse.ditto.model.connectivity.ConnectionId;
import org.eclipse.ditto.model.connectivity.ConnectionLifecycle;
import org.eclipse.ditto.model.connectivity.ConnectionType;
import org.eclipse.ditto.model.connectivity.ConnectionUriInvalidException;
import org.eclipse.ditto.model.connectivity.ConnectivityModelFactory;
import org.eclipse.ditto.model.connectivity.ConnectivityStatus;
import org.eclipse.ditto.model.connectivity.Credentials;
import org.eclipse.ditto.model.connectivity.ImmutablePayloadMappingDefinition;
import org.eclipse.ditto.model.connectivity.ImmutableSource;
import org.eclipse.ditto.model.connectivity.ImmutableSshTunnel;
import org.eclipse.ditto.model.connectivity.ImmutableTarget;
import org.eclipse.ditto.model.connectivity.MappingContext;
import org.eclipse.ditto.model.connectivity.PayloadMapping;
import org.eclipse.ditto.model.connectivity.PayloadMappingDefinition;
import org.eclipse.ditto.model.connectivity.Source;
import org.eclipse.ditto.model.connectivity.SshTunnel;
import org.eclipse.ditto.model.connectivity.Target;

@Immutable
final class ImmutableConnection
implements Connection {
    private final ConnectionId id;
    @Nullable
    private final String name;
    private final ConnectionType connectionType;
    private final ConnectivityStatus connectionStatus;
    private final ConnectionUri uri;
    @Nullable
    private final Credentials credentials;
    @Nullable
    private final String trustedCertificates;
    @Nullable
    private final ConnectionLifecycle lifecycle;
    private final List<Source> sources;
    private final List<Target> targets;
    private final int clientCount;
    private final boolean failOverEnabled;
    private final boolean validateCertificate;
    private final int processorPoolSize;
    private final Map<String, String> specificConfig;
    private final PayloadMappingDefinition payloadMappingDefinition;
    private final Set<String> tags;
    @Nullable
    private final SshTunnel sshTunnel;

    private ImmutableConnection(Builder builder) {
        this.id = (ConnectionId)ConditionChecker.checkNotNull((Object)builder.id, (String)"id");
        this.name = builder.name;
        this.connectionType = builder.connectionType;
        this.connectionStatus = (ConnectivityStatus)ConditionChecker.checkNotNull((Object)builder.connectionStatus, (String)"connectionStatus");
        this.credentials = builder.credentials;
        this.trustedCertificates = builder.trustedCertificates;
        this.uri = ConnectionUri.of((String)ConditionChecker.checkNotNull((Object)builder.uri, (String)"uri"));
        this.sources = Collections.unmodifiableList(new ArrayList(builder.sources));
        this.targets = Collections.unmodifiableList(new ArrayList(builder.targets));
        this.clientCount = builder.clientCount;
        this.failOverEnabled = builder.failOverEnabled;
        this.validateCertificate = builder.validateCertificate;
        this.processorPoolSize = builder.processorPoolSize;
        this.specificConfig = Collections.unmodifiableMap(new HashMap(builder.specificConfig));
        this.payloadMappingDefinition = builder.payloadMappingDefinition;
        this.tags = Collections.unmodifiableSet(new HashSet(builder.tags));
        this.lifecycle = builder.lifecycle;
        this.sshTunnel = builder.sshTunnel;
    }

    public static ConnectionBuilder getBuilder(ConnectionId id, ConnectionType connectionType, ConnectivityStatus connectionStatus, String uri) {
        return new Builder(connectionType).id(id).connectionStatus(connectionStatus).uri(uri);
    }

    public static ConnectionBuilder getBuilder(Connection connection) {
        ConditionChecker.checkNotNull((Object)connection, (String)"Connection");
        return new Builder(connection.getConnectionType()).id(connection.getId()).connectionStatus(connection.getConnectionStatus()).credentials(connection.getCredentials().orElse(null)).uri(connection.getUri()).trustedCertificates(connection.getTrustedCertificates().orElse(null)).failoverEnabled(connection.isFailoverEnabled()).validateCertificate(connection.isValidateCertificates()).processorPoolSize(connection.getProcessorPoolSize()).sources(connection.getSources()).targets(connection.getTargets()).clientCount(connection.getClientCount()).specificConfig(connection.getSpecificConfig()).payloadMappingDefinition(connection.getPayloadMappingDefinition()).name(connection.getName().orElse(null)).sshTunnel(connection.getSshTunnel().orElse(null)).tags(connection.getTags()).lifecycle(connection.getLifecycle().orElse(null));
    }

    public static Connection fromJson(JsonObject jsonObject) {
        ConnectionType type = ImmutableConnection.getConnectionTypeOrThrow(jsonObject);
        MappingContext mappingContext = jsonObject.getValue(Connection.JsonFields.MAPPING_CONTEXT).map(ConnectivityModelFactory::mappingContextFromJson).orElse(null);
        PayloadMappingDefinition payloadMappingDefinition = jsonObject.getValue(Connection.JsonFields.MAPPING_DEFINITIONS).map(ImmutablePayloadMappingDefinition::fromJson).orElse(ConnectivityModelFactory.emptyPayloadMappingDefinition());
        ConnectionBuilder builder = new Builder(type).id(ConnectionId.of((CharSequence)jsonObject.getValueOrThrow(Connection.JsonFields.ID))).connectionStatus(ImmutableConnection.getConnectionStatusOrThrow(jsonObject)).uri((String)jsonObject.getValueOrThrow(Connection.JsonFields.URI)).sources(ImmutableConnection.getSources(jsonObject)).targets(ImmutableConnection.getTargets(jsonObject)).name(jsonObject.getValue(Connection.JsonFields.NAME).orElse(null)).mappingContext(mappingContext).payloadMappingDefinition(payloadMappingDefinition).specificConfig(ImmutableConnection.getSpecificConfiguration(jsonObject)).tags(ImmutableConnection.getTags(jsonObject));
        jsonObject.getValue(Connection.JsonFields.LIFECYCLE).flatMap(ConnectionLifecycle::forName).ifPresent(builder::lifecycle);
        jsonObject.getValue(Connection.JsonFields.CREDENTIALS).ifPresent(builder::credentialsFromJson);
        jsonObject.getValue(Connection.JsonFields.CLIENT_COUNT).ifPresent(builder::clientCount);
        jsonObject.getValue(Connection.JsonFields.FAILOVER_ENABLED).ifPresent(builder::failoverEnabled);
        jsonObject.getValue(Connection.JsonFields.VALIDATE_CERTIFICATES).ifPresent(builder::validateCertificate);
        jsonObject.getValue(Connection.JsonFields.PROCESSOR_POOL_SIZE).ifPresent(builder::processorPoolSize);
        jsonObject.getValue(Connection.JsonFields.TRUSTED_CERTIFICATES).ifPresent(builder::trustedCertificates);
        jsonObject.getValue(Connection.JsonFields.SSH_TUNNEL).ifPresent(jsonFields -> builder.sshTunnel(ImmutableSshTunnel.fromJson(jsonFields)));
        return builder.build();
    }

    private static ConnectionType getConnectionTypeOrThrow(JsonObject jsonObject) {
        String readConnectionType = (String)jsonObject.getValueOrThrow(Connection.JsonFields.CONNECTION_TYPE);
        return ConnectionType.forName(readConnectionType).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Connection type <{0}> is invalid!", readConnectionType)).build());
    }

    private static ConnectivityStatus getConnectionStatusOrThrow(JsonObject jsonObject) {
        String readConnectionStatus = (String)jsonObject.getValueOrThrow(Connection.JsonFields.CONNECTION_STATUS);
        return ConnectivityStatus.forName(readConnectionStatus).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Connection status <{0}> is invalid!", readConnectionStatus)).build());
    }

    private static List<Source> getSources(JsonObject jsonObject) {
        Optional sourcesArray = jsonObject.getValue(Connection.JsonFields.SOURCES);
        if (sourcesArray.isPresent()) {
            JsonArray values = (JsonArray)sourcesArray.get();
            return IntStream.range(0, values.getSize()).mapToObj(index -> values.get(index).filter(JsonValue::isObject).map(JsonValue::asObject).map(valueAsObject -> ConnectivityModelFactory.sourceFromJson(valueAsObject, index))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<Target> getTargets(JsonObject jsonObject) {
        return jsonObject.getValue(Connection.JsonFields.TARGETS).map(array -> array.stream().filter(JsonValue::isObject).map(JsonValue::asObject).map(ConnectivityModelFactory::targetFromJson).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static Map<String, String> getSpecificConfiguration(JsonObject jsonObject) {
        return jsonObject.getValue(Connection.JsonFields.SPECIFIC_CONFIG).filter(JsonValue::isObject).map(JsonValue::asObject).map(JsonValueContainer::stream).map(jsonFields -> jsonFields.collect(Collectors.toMap(JsonField::getKeyName, f -> f.getValue().isString() ? f.getValue().asString() : f.getValue().toString()))).orElse(Collections.emptyMap());
    }

    private static Set<String> getTags(JsonObject jsonObject) {
        return jsonObject.getValue(Connection.JsonFields.TAGS).map(array -> array.stream().filter(JsonValue::isString).map(JsonValue::asString).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Override
    public ConnectionId getId() {
        return this.id;
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public ConnectivityStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    public List<Source> getSources() {
        return this.sources;
    }

    @Override
    public List<Target> getTargets() {
        return this.targets;
    }

    @Override
    public Optional<SshTunnel> getSshTunnel() {
        return Optional.ofNullable(this.sshTunnel);
    }

    @Override
    public int getClientCount() {
        return this.clientCount;
    }

    @Override
    public boolean isFailoverEnabled() {
        return this.failOverEnabled;
    }

    @Override
    public Optional<Credentials> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    @Override
    public Optional<String> getTrustedCertificates() {
        return Optional.ofNullable(this.trustedCertificates);
    }

    @Override
    public String getUri() {
        return this.uri.toString();
    }

    @Override
    public String getProtocol() {
        return this.uri.getProtocol();
    }

    @Override
    public Optional<String> getUsername() {
        return this.uri.getUserName();
    }

    @Override
    public Optional<String> getPassword() {
        return this.uri.getPassword();
    }

    @Override
    public String getHostname() {
        return this.uri.getHostname();
    }

    @Override
    public int getPort() {
        return this.uri.getPort();
    }

    @Override
    public Optional<String> getPath() {
        return this.uri.getPath();
    }

    @Override
    public boolean isValidateCertificates() {
        return this.validateCertificate;
    }

    @Override
    public int getProcessorPoolSize() {
        return this.processorPoolSize;
    }

    @Override
    public Map<String, String> getSpecificConfig() {
        return this.specificConfig;
    }

    @Override
    public PayloadMappingDefinition getPayloadMappingDefinition() {
        return this.payloadMappingDefinition;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public Optional<ConnectionLifecycle> getLifecycle() {
        return Optional.ofNullable(this.lifecycle);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(Connection.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        if (null != this.lifecycle) {
            jsonObjectBuilder.set(Connection.JsonFields.LIFECYCLE, (Object)this.lifecycle.name(), predicate);
        }
        jsonObjectBuilder.set(Connection.JsonFields.ID, (Object)String.valueOf(this.id), predicate);
        jsonObjectBuilder.set(Connection.JsonFields.NAME, (Object)this.name, predicate);
        jsonObjectBuilder.set(Connection.JsonFields.CONNECTION_TYPE, (Object)this.connectionType.getName(), predicate);
        jsonObjectBuilder.set(Connection.JsonFields.CONNECTION_STATUS, (Object)this.connectionStatus.getName(), predicate);
        jsonObjectBuilder.set(Connection.JsonFields.URI, (Object)this.uri.toString(), predicate);
        jsonObjectBuilder.set(Connection.JsonFields.SOURCES, (Object)((JsonArray)this.sources.stream().sorted(Comparator.comparingInt(Source::getIndex)).map(source -> (JsonObject)source.toJson(schemaVersion, thePredicate)).collect(JsonCollectors.valuesToArray())), predicate.and(Objects::nonNull));
        jsonObjectBuilder.set(Connection.JsonFields.TARGETS, (Object)((JsonArray)this.targets.stream().map(target -> (JsonObject)target.toJson(schemaVersion, thePredicate)).collect(JsonCollectors.valuesToArray())), predicate.and(Objects::nonNull));
        jsonObjectBuilder.set(Connection.JsonFields.CLIENT_COUNT, (Object)this.clientCount, predicate);
        jsonObjectBuilder.set(Connection.JsonFields.FAILOVER_ENABLED, (Object)this.failOverEnabled, predicate);
        jsonObjectBuilder.set(Connection.JsonFields.VALIDATE_CERTIFICATES, (Object)this.validateCertificate, predicate);
        jsonObjectBuilder.set(Connection.JsonFields.PROCESSOR_POOL_SIZE, (Object)this.processorPoolSize, predicate);
        if (!this.specificConfig.isEmpty()) {
            jsonObjectBuilder.set(Connection.JsonFields.SPECIFIC_CONFIG, (Object)((JsonObject)this.specificConfig.entrySet().stream().map(entry -> JsonField.newInstance((CharSequence)((CharSequence)entry.getKey()), (JsonValue)JsonValue.of((String)((String)entry.getValue())))).collect(JsonCollectors.fieldsToObject())), predicate);
        }
        if (!this.payloadMappingDefinition.isEmpty()) {
            jsonObjectBuilder.set(Connection.JsonFields.MAPPING_DEFINITIONS, (Object)((JsonObject)this.payloadMappingDefinition.toJson(schemaVersion, thePredicate)));
        }
        if (this.credentials != null) {
            jsonObjectBuilder.set(Connection.JsonFields.CREDENTIALS, (Object)this.credentials.toJson());
        }
        if (this.trustedCertificates != null) {
            jsonObjectBuilder.set(Connection.JsonFields.TRUSTED_CERTIFICATES, (Object)this.trustedCertificates, predicate);
        }
        if (this.sshTunnel != null) {
            jsonObjectBuilder.set(Connection.JsonFields.SSH_TUNNEL, (Object)((JsonObject)this.sshTunnel.toJson(predicate)), predicate);
        }
        jsonObjectBuilder.set(Connection.JsonFields.TAGS, (Object)((JsonArray)this.tags.stream().map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray())), predicate);
        return jsonObjectBuilder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableConnection that = (ImmutableConnection)o;
        return this.failOverEnabled == that.failOverEnabled && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.connectionType, that.connectionType) && Objects.equals(this.connectionStatus, that.connectionStatus) && Objects.equals(this.sources, that.sources) && Objects.equals(this.targets, that.targets) && Objects.equals(this.clientCount, that.clientCount) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.trustedCertificates, that.trustedCertificates) && Objects.equals(this.uri, that.uri) && Objects.equals(this.processorPoolSize, that.processorPoolSize) && Objects.equals(this.validateCertificate, that.validateCertificate) && Objects.equals(this.specificConfig, that.specificConfig) && Objects.equals(this.payloadMappingDefinition, that.payloadMappingDefinition) && Objects.equals((Object)this.lifecycle, (Object)that.lifecycle) && Objects.equals(this.sshTunnel, that.sshTunnel) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.connectionType, this.connectionStatus, this.sources, this.targets, this.clientCount, this.failOverEnabled, this.credentials, this.trustedCertificates, this.uri, this.validateCertificate, this.processorPoolSize, this.specificConfig, this.payloadMappingDefinition, this.sshTunnel, this.tags, this.lifecycle});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", name=" + this.name + ", connectionType=" + this.connectionType + ", connectionStatus=" + this.connectionStatus + ", failoverEnabled=" + this.failOverEnabled + ", credentials=" + this.credentials + ", trustedCertificates=hash:" + Objects.hash(this.trustedCertificates) + ", uri=" + this.uri.getUriStringWithMaskedPassword() + ", sources=" + this.sources + ", targets=" + this.targets + ", sshTunnel=" + this.sshTunnel + ", clientCount=" + this.clientCount + ", validateCertificate=" + this.validateCertificate + ", processorPoolSize=" + this.processorPoolSize + ", specificConfig=" + this.specificConfig + ", payloadMappingDefinition=" + this.payloadMappingDefinition + ", tags=" + this.tags + ", lifecycle=" + (Object)((Object)this.lifecycle) + "]";
    }

    @Immutable
    static final class ConnectionUri {
        private static final String MASKED_URI_PATTERN = "{0}://{1}{2}:{3,number,#}{4}";
        private static final String USERNAME_PASSWORD_SEPARATOR = ":";
        private final String uriString;
        private final String protocol;
        private final String hostname;
        private final int port;
        private final String path;
        @Nullable
        private final String userName;
        @Nullable
        private final String password;
        private final String uriStringWithMaskedPassword;

        private ConnectionUri(String theUriString) {
            URI uri;
            try {
                uri = new URI(theUriString).parseServerAuthority();
            }
            catch (URISyntaxException e) {
                throw (ConnectionUriInvalidException)ConnectionUriInvalidException.newBuilder(theUriString).build();
            }
            if (!ConnectionUri.isValid(uri)) {
                throw (ConnectionUriInvalidException)ConnectionUriInvalidException.newBuilder(theUriString).build();
            }
            this.uriString = uri.toASCIIString();
            this.protocol = uri.getScheme();
            this.hostname = uri.getHost();
            this.port = uri.getPort();
            this.path = uri.getPath();
            String userInfo = uri.getUserInfo();
            if (userInfo != null && userInfo.contains(USERNAME_PASSWORD_SEPARATOR)) {
                int separatorIndex = userInfo.indexOf(USERNAME_PASSWORD_SEPARATOR);
                this.userName = ConnectionUri.tryDecodeUriComponent(userInfo.substring(0, separatorIndex));
                this.password = ConnectionUri.tryDecodeUriComponent(userInfo.substring(separatorIndex + 1));
            } else {
                this.userName = null;
                this.password = null;
            }
            this.uriStringWithMaskedPassword = this.createUriStringWithMaskedPassword();
        }

        private static String tryDecodeUriComponent(String string) {
            try {
                String withoutPlus = string.replace("+", "%2B");
                return URLDecoder.decode(withoutPlus, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                return string;
            }
        }

        private String createUriStringWithMaskedPassword() {
            return MessageFormat.format(MASKED_URI_PATTERN, this.protocol, this.getUserCredentialsOrEmptyString(), this.hostname, this.port, this.getPathOrEmptyString());
        }

        private String getUserCredentialsOrEmptyString() {
            if (null != this.userName && null != this.password) {
                return this.userName + ":*****@";
            }
            return "";
        }

        private String getPathOrEmptyString() {
            return this.getPath().orElse("");
        }

        private static boolean isValid(URI uri) {
            return uri.getPort() > 0 && uri.getQuery() == null;
        }

        static ConnectionUri of(String uriString) {
            return new ConnectionUri(uriString);
        }

        String getProtocol() {
            return this.protocol;
        }

        Optional<String> getUserName() {
            return Optional.ofNullable(this.userName);
        }

        Optional<String> getPassword() {
            return Optional.ofNullable(this.password);
        }

        String getHostname() {
            return this.hostname;
        }

        int getPort() {
            return this.port;
        }

        Optional<String> getPath() {
            return this.path.isEmpty() ? Optional.empty() : Optional.of(this.path);
        }

        String getUriStringWithMaskedPassword() {
            return this.uriStringWithMaskedPassword;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionUri that = (ConnectionUri)o;
            return Objects.equals(this.uriString, that.uriString);
        }

        public int hashCode() {
            return Objects.hash(this.uriString);
        }

        public String toString() {
            return this.uriString;
        }
    }

    @NotThreadSafe
    private static final class Builder
    implements ConnectionBuilder {
        private static final String MIGRATED_MAPPER_ID = "javascript";
        private final ConnectionType connectionType;
        @Nullable
        private ConnectionId id;
        @Nullable
        private ConnectivityStatus connectionStatus;
        @Nullable
        private String uri;
        @Nullable
        private String name = null;
        @Nullable
        private Credentials credentials;
        @Nullable
        private MappingContext mappingContext = null;
        @Nullable
        private String trustedCertificates;
        @Nullable
        private ConnectionLifecycle lifecycle = null;
        @Nullable
        private SshTunnel sshTunnel = null;
        private Set<String> tags = new HashSet<String>();
        private boolean failOverEnabled = true;
        private boolean validateCertificate = true;
        private final List<Source> sources = new ArrayList<Source>();
        private final List<Target> targets = new ArrayList<Target>();
        private int clientCount = 1;
        private int processorPoolSize = 5;
        private PayloadMappingDefinition payloadMappingDefinition = ConnectivityModelFactory.emptyPayloadMappingDefinition();
        private final Map<String, String> specificConfig = new HashMap<String, String>();

        private Builder(ConnectionType connectionType) {
            this.connectionType = (ConnectionType)ConditionChecker.checkNotNull((Object)connectionType, (String)"Connection Type");
        }

        private static boolean isBlankOrNull(@Nullable String toTest) {
            return null == toTest || toTest.trim().isEmpty();
        }

        @Override
        public ConnectionBuilder id(ConnectionId id) {
            this.id = (ConnectionId)ConditionChecker.checkNotNull((Object)id, (String)"ID");
            return this;
        }

        @Override
        public ConnectionBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public ConnectionBuilder credentials(@Nullable Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public Builder trustedCertificates(@Nullable String trustedCertificates) {
            this.trustedCertificates = Builder.isBlankOrNull(trustedCertificates) ? null : trustedCertificates;
            return this;
        }

        @Override
        public ConnectionBuilder uri(String uri) {
            this.uri = (String)ConditionChecker.checkNotNull((Object)uri, (String)"URI");
            return this;
        }

        @Override
        public ConnectionBuilder connectionStatus(ConnectivityStatus connectionStatus) {
            this.connectionStatus = (ConnectivityStatus)ConditionChecker.checkNotNull((Object)connectionStatus, (String)"ConnectionStatus");
            return this;
        }

        @Override
        public ConnectionBuilder failoverEnabled(boolean failOverEnabled) {
            this.failOverEnabled = failOverEnabled;
            return this;
        }

        @Override
        public ConnectionBuilder validateCertificate(boolean validateCertificate) {
            this.validateCertificate = validateCertificate;
            return this;
        }

        @Override
        public ConnectionBuilder processorPoolSize(int processorPoolSize) {
            ConditionChecker.checkArgument((Object)processorPoolSize, ps -> ps > 0, () -> "The consumer count must be positive!");
            this.processorPoolSize = processorPoolSize;
            return this;
        }

        @Override
        public ConnectionBuilder sources(List<Source> sources) {
            this.sources.addAll((Collection)ConditionChecker.checkNotNull(sources, (String)"sources"));
            return this;
        }

        @Override
        public ConnectionBuilder targets(List<Target> targets) {
            this.targets.addAll((Collection)ConditionChecker.checkNotNull(targets, (String)"targets"));
            return this;
        }

        @Override
        public ConnectionBuilder setSources(List<Source> sources) {
            this.sources.clear();
            return this.sources(sources);
        }

        @Override
        public ConnectionBuilder setTargets(List<Target> targets) {
            this.targets.clear();
            return this.targets(targets);
        }

        @Override
        public ConnectionBuilder clientCount(int clientCount) {
            ConditionChecker.checkArgument((Object)clientCount, ps -> ps > 0, () -> "The client count must be > 0!");
            this.clientCount = clientCount;
            return this;
        }

        @Override
        public ConnectionBuilder specificConfig(Map<String, String> specificConfig) {
            this.specificConfig.putAll((Map)ConditionChecker.checkNotNull(specificConfig, (String)"Specific Config"));
            return this;
        }

        @Override
        public ConnectionBuilder mappingContext(@Nullable MappingContext mappingContext) {
            this.mappingContext = mappingContext;
            return this;
        }

        @Override
        public ConnectionBuilder tags(Collection<String> tags) {
            this.tags = new HashSet<String>((Collection)ConditionChecker.checkNotNull(tags, (String)"tags to set"));
            return this;
        }

        @Override
        public ConnectionBuilder tag(String tag) {
            this.tags.add((String)ConditionChecker.checkNotNull((Object)tag, (String)"tag to set"));
            return this;
        }

        @Override
        public ConnectionBuilder lifecycle(@Nullable ConnectionLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public ConnectionBuilder sshTunnel(@Nullable SshTunnel sshTunnel) {
            this.sshTunnel = sshTunnel;
            return this;
        }

        @Override
        public ConnectionBuilder payloadMappingDefinition(PayloadMappingDefinition payloadMappingDefinition) {
            this.payloadMappingDefinition = payloadMappingDefinition;
            return this;
        }

        @Override
        public Connection build() {
            this.checkSourceAndTargetAreValid();
            this.checkAuthorizationContextsAreValid();
            this.migrateLegacyConfigurationOnTheFly();
            return new ImmutableConnection(this);
        }

        private boolean shouldMigrateMappingContext() {
            return this.mappingContext != null;
        }

        private void migrateLegacyConfigurationOnTheFly() {
            if (this.shouldMigrateMappingContext()) {
                this.payloadMappingDefinition = this.payloadMappingDefinition.withDefinition(MIGRATED_MAPPER_ID, this.mappingContext);
            }
            this.setSources(this.sources.stream().map(this::migrateSource).collect(Collectors.toList()));
            this.setTargets(this.targets.stream().map(this::migrateTarget).collect(Collectors.toList()));
        }

        private Source migrateSource(Source source) {
            Source sourceAfterReplyTargetMigration = ImmutableSource.migrateReplyTarget(source, this.connectionType);
            if (this.shouldMigrateMappingContext()) {
                return new ImmutableSource.Builder(sourceAfterReplyTargetMigration).payloadMapping(this.addMigratedPayloadMappings(source.getPayloadMapping())).build();
            }
            return sourceAfterReplyTargetMigration;
        }

        private Target migrateTarget(Target target) {
            boolean shouldAddHeaderMapping = this.shouldAddDefaultHeaderMappingToTarget(this.connectionType);
            boolean shouldMigrateMappingContext = this.shouldMigrateMappingContext();
            if (shouldMigrateMappingContext || shouldAddHeaderMapping) {
                ImmutableTarget.Builder builder = new ImmutableTarget.Builder(target);
                if (shouldMigrateMappingContext) {
                    builder.payloadMapping(this.addMigratedPayloadMappings(target.getPayloadMapping()));
                }
                if (shouldAddHeaderMapping) {
                    builder.headerMapping(target.getHeaderMapping().orElse(ImmutableTarget.DEFAULT_HEADER_MAPPING));
                }
                return builder.build();
            }
            return target;
        }

        private boolean shouldAddDefaultHeaderMappingToTarget(ConnectionType connectionType) {
            switch (connectionType) {
                case AMQP_091: 
                case AMQP_10: 
                case KAFKA: 
                case MQTT_5: {
                    return true;
                }
            }
            return false;
        }

        private PayloadMapping addMigratedPayloadMappings(PayloadMapping payloadMapping) {
            ArrayList<String> merged = new ArrayList<String>(payloadMapping.getMappings());
            merged.add(MIGRATED_MAPPER_ID);
            return ConnectivityModelFactory.newPayloadMapping(merged);
        }

        private void checkSourceAndTargetAreValid() {
            if (this.sources.isEmpty() && this.targets.isEmpty()) {
                throw (ConnectionConfigurationInvalidException)ConnectionConfigurationInvalidException.newBuilder("Either a source or a target must be specified in the configuration of a connection!").build();
            }
        }

        private void checkAuthorizationContextsAreValid() {
            Set sourcesWithoutAuthContext = this.sources.stream().filter(source -> source.getAuthorizationContext().isEmpty()).flatMap(source -> source.getAddresses().stream()).collect(Collectors.toSet());
            Set targetsWithoutAuthContext = this.targets.stream().filter(target -> target.getAuthorizationContext().isEmpty()).map(Target::getAddress).collect(Collectors.toSet());
            if (!sourcesWithoutAuthContext.isEmpty() || !targetsWithoutAuthContext.isEmpty()) {
                StringBuilder message = new StringBuilder("The ");
                if (!sourcesWithoutAuthContext.isEmpty()) {
                    message.append("Sources ").append(sourcesWithoutAuthContext);
                }
                if (!sourcesWithoutAuthContext.isEmpty() && !targetsWithoutAuthContext.isEmpty()) {
                    message.append(" and ");
                }
                if (!targetsWithoutAuthContext.isEmpty()) {
                    message.append("Targets ").append(targetsWithoutAuthContext);
                }
                message.append(" are missing an authorization context.");
                throw (ConnectionConfigurationInvalidException)ConnectionConfigurationInvalidException.newBuilder(message.toString()).build();
            }
        }
    }
}

