/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.connectivity.FilteredTopic;
import org.eclipse.ditto.model.connectivity.HeaderMapping;
import org.eclipse.ditto.model.connectivity.Target;

abstract class DelegateTarget
implements Target {
    protected final Target delegate;

    DelegateTarget(Target delegate) {
        this.delegate = (Target)ConditionChecker.checkNotNull((Object)delegate, (String)"delegate");
    }

    @Override
    public String getAddress() {
        return this.delegate.getAddress();
    }

    @Override
    public String getOriginalAddress() {
        return this.delegate.getOriginalAddress();
    }

    @Override
    public Set<FilteredTopic> getTopics() {
        return this.delegate.getTopics();
    }

    @Override
    public AuthorizationContext getAuthorizationContext() {
        return this.delegate.getAuthorizationContext();
    }

    @Override
    public Optional<HeaderMapping> getHeaderMapping() {
        return this.delegate.getHeaderMapping();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegateTarget that = (DelegateTarget)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [delegate=" + this.delegate + "]";
    }
}

