/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.model.connectivity.ClientCertificateCredentials;
import org.eclipse.ditto.model.connectivity.CredentialsVisitor;
import org.eclipse.ditto.model.connectivity.SshPublicKeyCredentials;
import org.eclipse.ditto.model.connectivity.UserPasswordCredentials;

public interface Credentials {
    public <T> T accept(CredentialsVisitor<T> var1);

    public JsonObject toJson();

    public static void registerDeserializer(String type, Function<JsonObject, Credentials> deserializer) {
        JsonFields.DESERIALIZER_MAP.put(type, deserializer);
    }

    public static Credentials fromJson(JsonObject jsonObject) {
        String type = (String)jsonObject.getValueOrThrow(JsonFields.TYPE);
        Function deserializer = (Function)JsonFields.DESERIALIZER_MAP.get(type);
        if (deserializer == null) {
            throw (JsonParseException)JsonParseException.newBuilder().message(String.format("Unknown credential type <%s>", type)).description("Original JSON: " + jsonObject.toString()).build();
        }
        return (Credentials)deserializer.apply(jsonObject);
    }

    public static abstract class JsonFields {
        private static final ConcurrentMap<String, Function<JsonObject, Credentials>> DESERIALIZER_MAP = new ConcurrentHashMap<String, Function<JsonObject, Credentials>>();
        public static final JsonFieldDefinition<String> TYPE = JsonFieldDefinition.ofString((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[0]);

        static {
            Credentials.registerDeserializer("client-cert", ClientCertificateCredentials::fromJson);
            Credentials.registerDeserializer("public-key", SshPublicKeyCredentials::fromJson);
            Credentials.registerDeserializer("plain", UserPasswordCredentials::fromJson);
        }
    }
}

