/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.connectivity.AddressMetric;
import org.eclipse.ditto.model.connectivity.Connection;
import org.eclipse.ditto.model.connectivity.ConnectionBuilder;
import org.eclipse.ditto.model.connectivity.ConnectionId;
import org.eclipse.ditto.model.connectivity.ConnectionMetrics;
import org.eclipse.ditto.model.connectivity.ConnectionType;
import org.eclipse.ditto.model.connectivity.ConnectivityStatus;
import org.eclipse.ditto.model.connectivity.Credentials;
import org.eclipse.ditto.model.connectivity.Enforcement;
import org.eclipse.ditto.model.connectivity.FilteredTopic;
import org.eclipse.ditto.model.connectivity.FilteredTopicBuilder;
import org.eclipse.ditto.model.connectivity.HeaderMapping;
import org.eclipse.ditto.model.connectivity.ImmutableAddressMetric;
import org.eclipse.ditto.model.connectivity.ImmutableConnection;
import org.eclipse.ditto.model.connectivity.ImmutableConnectionMetrics;
import org.eclipse.ditto.model.connectivity.ImmutableEnforcement;
import org.eclipse.ditto.model.connectivity.ImmutableFilteredTopic;
import org.eclipse.ditto.model.connectivity.ImmutableHeaderMapping;
import org.eclipse.ditto.model.connectivity.ImmutableLogEntry;
import org.eclipse.ditto.model.connectivity.ImmutableMappingContext;
import org.eclipse.ditto.model.connectivity.ImmutableMeasurement;
import org.eclipse.ditto.model.connectivity.ImmutablePayloadMapping;
import org.eclipse.ditto.model.connectivity.ImmutablePayloadMappingDefinition;
import org.eclipse.ditto.model.connectivity.ImmutableResourceStatus;
import org.eclipse.ditto.model.connectivity.ImmutableSource;
import org.eclipse.ditto.model.connectivity.ImmutableSourceMetrics;
import org.eclipse.ditto.model.connectivity.ImmutableSshTunnel;
import org.eclipse.ditto.model.connectivity.ImmutableTarget;
import org.eclipse.ditto.model.connectivity.ImmutableTargetMetrics;
import org.eclipse.ditto.model.connectivity.LogCategory;
import org.eclipse.ditto.model.connectivity.LogEntry;
import org.eclipse.ditto.model.connectivity.LogEntryBuilder;
import org.eclipse.ditto.model.connectivity.LogLevel;
import org.eclipse.ditto.model.connectivity.LogType;
import org.eclipse.ditto.model.connectivity.MappingContext;
import org.eclipse.ditto.model.connectivity.MappingContextBuilder;
import org.eclipse.ditto.model.connectivity.Measurement;
import org.eclipse.ditto.model.connectivity.MetricType;
import org.eclipse.ditto.model.connectivity.PayloadMapping;
import org.eclipse.ditto.model.connectivity.PayloadMappingDefinition;
import org.eclipse.ditto.model.connectivity.ResourceStatus;
import org.eclipse.ditto.model.connectivity.Source;
import org.eclipse.ditto.model.connectivity.SourceBuilder;
import org.eclipse.ditto.model.connectivity.SourceMetrics;
import org.eclipse.ditto.model.connectivity.SshTunnel;
import org.eclipse.ditto.model.connectivity.SshTunnelBuilder;
import org.eclipse.ditto.model.connectivity.Target;
import org.eclipse.ditto.model.connectivity.TargetBuilder;
import org.eclipse.ditto.model.connectivity.TargetMetrics;
import org.eclipse.ditto.model.connectivity.Topic;

@Immutable
public final class ConnectivityModelFactory {
    public static final String SOURCE_ADDRESS_ENFORCEMENT = "{{ source:address }}";
    private static final HeaderMapping EMPTY_HEADER_MAPPING = ConnectivityModelFactory.newHeaderMapping(new HashMap<String, String>());

    private ConnectivityModelFactory() {
        throw new AssertionError();
    }

    public static ConnectionBuilder newConnectionBuilder(ConnectionId id, ConnectionType connectionType, ConnectivityStatus connectionStatus, String uri) {
        return ImmutableConnection.getBuilder(id, connectionType, connectionStatus, uri);
    }

    public static ConnectionBuilder newConnectionBuilder(Connection connection) {
        return ImmutableConnection.getBuilder(connection);
    }

    public static Connection connectionFromJson(JsonObject jsonObject) {
        return ImmutableConnection.fromJson(jsonObject);
    }

    public static Measurement newMeasurement(MetricType metricType, boolean success, Map<Duration, Long> values, @Nullable Instant lastMessageAt) {
        return new ImmutableMeasurement(metricType, success, values, lastMessageAt);
    }

    public static ConnectionMetrics connectionMetricsFromJson(JsonObject jsonObject) {
        return ImmutableConnectionMetrics.fromJson(jsonObject);
    }

    public static ConnectionMetrics newConnectionMetrics(AddressMetric inboundMetrics, AddressMetric outboundMetrics) {
        return ImmutableConnectionMetrics.of(inboundMetrics, outboundMetrics);
    }

    public static ConnectionMetrics emptyConnectionMetrics() {
        return ImmutableConnectionMetrics.of(ConnectivityModelFactory.emptyAddressMetric(), ConnectivityModelFactory.emptyAddressMetric());
    }

    public static SourceMetrics newSourceMetrics(Map<String, AddressMetric> addressMetrics) {
        return ImmutableSourceMetrics.of(addressMetrics);
    }

    public static SourceMetrics emptySourceMetrics() {
        return ImmutableSourceMetrics.of(Collections.emptyMap());
    }

    public static SourceMetrics sourceMetricsFromJson(JsonObject jsonObject) {
        return ImmutableSourceMetrics.fromJson(jsonObject);
    }

    public static TargetMetrics newTargetMetrics(Map<String, AddressMetric> addressMetrics) {
        return ImmutableTargetMetrics.of(addressMetrics);
    }

    public static TargetMetrics emptyTargetMetrics() {
        return ImmutableTargetMetrics.of(Collections.emptyMap());
    }

    public static TargetMetrics targetMetricsFromJson(JsonObject jsonObject) {
        return ImmutableTargetMetrics.fromJson(jsonObject);
    }

    public static ResourceStatus newClientStatus(String client, ConnectivityStatus status, @Nullable String statusDetails) {
        return ImmutableResourceStatus.of(ResourceStatus.ResourceType.CLIENT, client, status, null, statusDetails);
    }

    public static ResourceStatus newClientStatus(String client, ConnectivityStatus status, @Nullable String statusDetails, Instant inStateSince) {
        return ImmutableResourceStatus.of(ResourceStatus.ResourceType.CLIENT, client, status, null, statusDetails, inStateSince);
    }

    public static ResourceStatus newSshTunnelStatus(String client, ConnectivityStatus status, @Nullable String statusDetails, Instant inStateSince) {
        return ImmutableResourceStatus.of(ResourceStatus.ResourceType.SSH_TUNNEL, client, status, null, statusDetails, inStateSince);
    }

    public static ResourceStatus newSourceStatus(String client, ConnectivityStatus status, @Nullable String address, @Nullable String statusDetails) {
        return ImmutableResourceStatus.of(ResourceStatus.ResourceType.SOURCE, client, status, address, statusDetails);
    }

    public static ResourceStatus newTargetStatus(String client, ConnectivityStatus status, @Nullable String address, @Nullable String statusDetails) {
        return ImmutableResourceStatus.of(ResourceStatus.ResourceType.TARGET, client, status, address, statusDetails);
    }

    public static ResourceStatus newStatusUpdate(String client, ConnectivityStatus status, @Nullable String address, @Nullable String statusDetails) {
        return ImmutableResourceStatus.of(ResourceStatus.ResourceType.UNKNOWN, client, status, address, statusDetails);
    }

    public static ResourceStatus newStatusUpdate(String client, ConnectivityStatus status, @Nullable String address, @Nullable String statusDetails, Instant inStatusSince) {
        return ImmutableResourceStatus.of(ResourceStatus.ResourceType.UNKNOWN, client, status, address, statusDetails, inStatusSince);
    }

    public static ResourceStatus resourceStatusFromJson(JsonObject jsonObject) {
        return ImmutableResourceStatus.fromJson(jsonObject);
    }

    public static AddressMetric newAddressMetric(Set<Measurement> measurements) {
        return ImmutableAddressMetric.of(measurements);
    }

    public static AddressMetric newAddressMetric(AddressMetric addressMetric, Collection<Measurement> additionalMeasurements) {
        HashSet<Measurement> set = new HashSet<Measurement>(addressMetric.getMeasurements());
        set.addAll(additionalMeasurements);
        return ImmutableAddressMetric.of(set);
    }

    public static AddressMetric emptyAddressMetric() {
        return ImmutableAddressMetric.of(Collections.emptySet());
    }

    public static AddressMetric addressMetricFromJson(JsonObject jsonObject) {
        return ImmutableAddressMetric.fromJson(jsonObject);
    }

    public static MappingContextBuilder newMappingContextBuilder(String mappingEngine, JsonObject options) {
        return new ImmutableMappingContext.Builder(mappingEngine, options);
    }

    public static MappingContext newMappingContext(String mappingEngine, Map<String, String> options) {
        return ConnectivityModelFactory.newMappingContextBuilder(mappingEngine, (JsonObject)options.entrySet().stream().map(entry -> JsonField.newInstance((CharSequence)((CharSequence)entry.getKey()), (JsonValue)JsonValue.of((String)((String)entry.getValue())))).collect(JsonCollectors.fieldsToObject())).build();
    }

    public static MappingContext newMappingContext(String mappingEngine, JsonObject options) {
        return ImmutableMappingContext.of(mappingEngine, options);
    }

    public static MappingContext newMappingContext(String mappingEngine, JsonObject options, Map<String, String> incomingConditions, Map<String, String> outgoingConditions) {
        return ConnectivityModelFactory.newMappingContextBuilder(mappingEngine, options).incomingConditions(incomingConditions).outgoingConditions(outgoingConditions).build();
    }

    public static MappingContext mappingContextFromJson(JsonObject jsonObject) {
        return ImmutableMappingContext.fromJson(jsonObject);
    }

    static Map<String, MappingContext> mappingsFromJson(JsonObject jsonObject) {
        return jsonObject.stream().filter(f -> f.getValue().isObject()).map(field -> {
            String id = field.getKeyName();
            MappingContext context = ImmutableMappingContext.fromJson(field.getValue().asObject());
            return new AbstractMap.SimpleImmutableEntry<String, MappingContext>(id, context);
        }).collect(ConnectivityModelFactory.fromEntries());
    }

    private static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> fromEntries() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static PayloadMappingDefinition emptyPayloadMappingDefinition() {
        return ImmutablePayloadMappingDefinition.empty();
    }

    public static PayloadMappingDefinition newPayloadMappingDefinition(Map<String, MappingContext> definitions) {
        return ImmutablePayloadMappingDefinition.from(definitions);
    }

    public static PayloadMappingDefinition newPayloadMappingDefinition(String id, MappingContext mappingContext) {
        HashMap<String, MappingContext> definitions = new HashMap<String, MappingContext>();
        definitions.put(id, mappingContext);
        return ImmutablePayloadMappingDefinition.from(definitions);
    }

    public static PayloadMapping emptyPayloadMapping() {
        return ImmutablePayloadMapping.empty();
    }

    public static PayloadMapping newPayloadMapping(List<String> mappings) {
        return ImmutablePayloadMapping.from(mappings);
    }

    public static PayloadMapping newPayloadMapping(String ... mappings) {
        if (mappings == null || mappings.length == 0) {
            return ConnectivityModelFactory.emptyPayloadMapping();
        }
        return ImmutablePayloadMapping.from(Arrays.asList(mappings));
    }

    public static PayloadMapping newPayloadMapping(JsonArray jsonArray) {
        return ImmutablePayloadMapping.fromJson(jsonArray);
    }

    public static SourceBuilder<?> newSourceBuilder() {
        return new ImmutableSource.Builder();
    }

    public static SourceBuilder<?> newSourceBuilder(Source source) {
        return new ImmutableSource.Builder(source);
    }

    public static Source newSource(AuthorizationContext authorizationContext, String address) {
        return ConnectivityModelFactory.newSourceBuilder().address(address).authorizationContext(authorizationContext).build();
    }

    public static Source newSource(AuthorizationContext authorizationContext, String address, int index) {
        return ConnectivityModelFactory.newSourceBuilder().address(address).authorizationContext(authorizationContext).index(index).build();
    }

    public static TargetBuilder newTargetBuilder() {
        return new ImmutableTarget.Builder();
    }

    public static TargetBuilder newTargetBuilder(Target target) {
        return new ImmutableTarget.Builder(target);
    }

    public static Target newTarget(Target target, String address, @Nullable Integer qos) {
        return ConnectivityModelFactory.newTargetBuilder().address(address).originalAddress(target.getOriginalAddress()).authorizationContext(target.getAuthorizationContext()).headerMapping(target.getHeaderMapping().orElse(null)).qos(qos).topics(target.getTopics()).build();
    }

    public static Target newTarget(Target target, String address, @Nullable Integer qos, AcknowledgementLabel label) {
        return ConnectivityModelFactory.newTargetBuilder().address(address).originalAddress(target.getOriginalAddress()).authorizationContext(target.getAuthorizationContext()).headerMapping(target.getHeaderMapping().orElse(null)).qos(qos).issuedAcknowledgementLabel(label).topics(target.getTopics()).build();
    }

    @Deprecated
    public static Target newTarget(String address, AuthorizationContext authorizationContext, @Nullable HeaderMapping headerMapping, @Nullable Integer qos, Set<FilteredTopic> topics) {
        return ConnectivityModelFactory.newTargetBuilder().address(address).originalAddress(address).qos(qos).authorizationContext(authorizationContext).topics(topics).headerMapping(headerMapping).build();
    }

    @Deprecated
    public static Target newTarget(String address, String originalAddress, AuthorizationContext authorizationContext, @Nullable HeaderMapping headerMapping, @Nullable Integer qos, Set<FilteredTopic> topics) {
        return ConnectivityModelFactory.newTargetBuilder().address(address).originalAddress(originalAddress).headerMapping(headerMapping).qos(qos).authorizationContext(authorizationContext).topics(topics).build();
    }

    @Deprecated
    public static Target newTarget(String address, AuthorizationContext authorizationContext, @Nullable HeaderMapping headerMapping, @Nullable Integer qos, FilteredTopic requiredTopic, FilteredTopic ... additionalTopics) {
        return ConnectivityModelFactory.newTargetBuilder().address(address).authorizationContext(authorizationContext).headerMapping(headerMapping).qos(qos).topics(requiredTopic, additionalTopics).build();
    }

    @Deprecated
    public static Target newTarget(String address, AuthorizationContext authorizationContext, @Nullable HeaderMapping headerMapping, @Nullable Integer qos, Topic requiredTopic, Topic ... additionalTopics) {
        return ConnectivityModelFactory.newTargetBuilder().address(address).authorizationContext(authorizationContext).headerMapping(headerMapping).qos(qos).topics(requiredTopic, additionalTopics).build();
    }

    public static SshTunnelBuilder newSshTunnelBuilder(boolean enabled, Credentials credentials, String uri) {
        return new ImmutableSshTunnel.Builder(enabled, credentials, uri);
    }

    public static SshTunnelBuilder newSshTunnelBuilder(SshTunnel sshTunnel) {
        return new ImmutableSshTunnel.Builder(sshTunnel);
    }

    public static SshTunnel sshTunnelFromJson(JsonObject jsonObject) {
        return ImmutableSshTunnel.fromJson(jsonObject);
    }

    public static SshTunnel newSshTunnel(boolean enabled, Credentials credentials, boolean validateHost, List<String> knownHosts, String uri) {
        return new ImmutableSshTunnel.Builder(enabled, credentials, validateHost, knownHosts, uri).build();
    }

    public static SshTunnel newSshTunnel(boolean enabled, Credentials credentials, String uri) {
        return new ImmutableSshTunnel.Builder(enabled, credentials, uri).build();
    }

    public static Source sourceFromJson(JsonObject jsonObject, int index) {
        return ImmutableSource.fromJson(jsonObject, index);
    }

    public static Target targetFromJson(JsonObject jsonObject) {
        return ImmutableTarget.fromJson(jsonObject);
    }

    @Deprecated
    public static FilteredTopic newFilteredTopic(Topic topic) {
        return ConnectivityModelFactory.newFilteredTopicBuilder(topic).build();
    }

    @Deprecated
    public static FilteredTopic newFilteredTopic(Topic topic, @Nullable String filter) {
        return ConnectivityModelFactory.newFilteredTopicBuilder(topic).withFilter(filter).build();
    }

    @Deprecated
    public static FilteredTopic newFilteredTopic(Topic topic, List<String> namespaces) {
        return ConnectivityModelFactory.newFilteredTopicBuilder(topic).withNamespaces(namespaces).build();
    }

    @Deprecated
    public static FilteredTopic newFilteredTopic(Topic topic, List<String> namespaces, @Nullable String filter) {
        return ConnectivityModelFactory.newFilteredTopicBuilder(topic).withNamespaces(namespaces).withFilter(filter).build();
    }

    public static FilteredTopic newFilteredTopic(String topicString) {
        return ImmutableFilteredTopic.fromString(topicString);
    }

    public static FilteredTopicBuilder newFilteredTopicBuilder(Topic topic) {
        return ImmutableFilteredTopic.getBuilder(topic);
    }

    public static Enforcement newEnforcement(String input, Set<String> filters) {
        return ImmutableEnforcement.of(input, filters);
    }

    public static Enforcement newEnforcement(String input, String requiredFilter, String ... additionalFilters) {
        HashSet<String> filters = new HashSet<String>(1 + additionalFilters.length);
        filters.add(requiredFilter);
        Collections.addAll(filters, additionalFilters);
        return ConnectivityModelFactory.newEnforcement(input, filters);
    }

    public static Enforcement newSourceAddressEnforcement(Set<String> filters) {
        return ConnectivityModelFactory.newEnforcement(SOURCE_ADDRESS_ENFORCEMENT, filters);
    }

    public static Enforcement newSourceAddressEnforcement(String requiredFilter, String ... additionalFilters) {
        return ConnectivityModelFactory.newEnforcement(SOURCE_ADDRESS_ENFORCEMENT, requiredFilter, additionalFilters);
    }

    public static Enforcement newEnforcement(Enforcement enforcement) {
        return ImmutableEnforcement.of(enforcement.getInput(), enforcement.getFilters());
    }

    public static HeaderMapping emptyHeaderMapping() {
        return EMPTY_HEADER_MAPPING;
    }

    public static HeaderMapping newHeaderMapping(Map<String, String> mapping) {
        return new ImmutableHeaderMapping(mapping);
    }

    public static HeaderMapping newHeaderMapping(JsonObject jsonObject) {
        return ImmutableHeaderMapping.fromJson(jsonObject);
    }

    public static LogEntry logEntryFromJson(JsonObject jsonObject) {
        return ImmutableLogEntry.fromJson(jsonObject);
    }

    public static LogEntryBuilder newLogEntryBuilder(String correlationId, Instant timestamp, LogCategory logCategory, LogType logType, LogLevel logLevel, String message) {
        return ImmutableLogEntry.getBuilder(correlationId, timestamp, logCategory, logType, logLevel, message);
    }
}

