/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:internalerror")
@Immutable
public final class ConnectivityInternalErrorException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:internalerror";
    private static final String DEFAULT_MESSAGE = "There was a rare case of an unexpected internal error.";
    private static final String DEFAULT_DESCRIPTION = "Please contact the service team.";
    private static final long serialVersionUID = -3752156243417604562L;

    private ConnectivityInternalErrorException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.INTERNAL_SERVER_ERROR, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static ConnectivityInternalErrorException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (ConnectivityInternalErrorException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static ConnectivityInternalErrorException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ConnectivityInternalErrorException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ConnectivityInternalErrorException> {
        private Builder() {
            this.message(ConnectivityInternalErrorException.DEFAULT_MESSAGE);
            this.description(ConnectivityInternalErrorException.DEFAULT_DESCRIPTION);
        }

        protected ConnectivityInternalErrorException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new ConnectivityInternalErrorException(dittoHeaders, message, description, cause, href);
        }
    }
}

