/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:connection.id.enforcement.failed")
@Immutable
public final class ConnectionSignalIdEnforcementFailedException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:connection.id.enforcement.failed";
    private static final String MESSAGE_TEMPLATE = "The configured filters could not be matched against the given target with ID ''{0}''.";
    private static final String DEFAULT_DESCRIPTION = "Either modify the configured filter or ensure that the message is sent via the correct ID.";
    private static final long serialVersionUID = 2672495302389903822L;

    private ConnectionSignalIdEnforcementFailedException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String target) {
        return new Builder(target);
    }

    public static ConnectionSignalIdEnforcementFailedException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (ConnectionSignalIdEnforcementFailedException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static ConnectionSignalIdEnforcementFailedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ConnectionSignalIdEnforcementFailedException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ConnectionSignalIdEnforcementFailedException> {
        private Builder() {
            this.description(ConnectionSignalIdEnforcementFailedException.DEFAULT_DESCRIPTION);
        }

        private Builder(String target) {
            this();
            this.message(MessageFormat.format(ConnectionSignalIdEnforcementFailedException.MESSAGE_TEMPLATE, target));
        }

        protected ConnectionSignalIdEnforcementFailedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new ConnectionSignalIdEnforcementFailedException(dittoHeaders, message, description, cause, href);
        }
    }
}

