/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:connection.configuration.invalid")
@Immutable
public final class ConnectionConfigurationInvalidException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:connection.configuration.invalid";
    private static final String DEFAULT_DESCRIPTION = "Make sure all required properties are set and valid in the configuration.";
    private static final long serialVersionUID = 8387870996010060745L;

    private ConnectionConfigurationInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String errorMessage) {
        return new Builder(errorMessage);
    }

    public static ConnectionConfigurationInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (ConnectionConfigurationInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static ConnectionConfigurationInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ConnectionConfigurationInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ConnectionConfigurationInvalidException> {
        private Builder() {
            this.description(ConnectionConfigurationInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(String errorMessage) {
            this();
            this.message(errorMessage);
        }

        protected ConnectionConfigurationInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new ConnectionConfigurationInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

