/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.connectivity.Connection;
import org.eclipse.ditto.model.connectivity.ConnectionId;
import org.eclipse.ditto.model.connectivity.ConnectionLifecycle;
import org.eclipse.ditto.model.connectivity.ConnectivityStatus;
import org.eclipse.ditto.model.connectivity.Credentials;
import org.eclipse.ditto.model.connectivity.MappingContext;
import org.eclipse.ditto.model.connectivity.PayloadMappingDefinition;
import org.eclipse.ditto.model.connectivity.Source;
import org.eclipse.ditto.model.connectivity.SshTunnel;
import org.eclipse.ditto.model.connectivity.Target;

public interface ConnectionBuilder {
    public ConnectionBuilder id(ConnectionId var1);

    public ConnectionBuilder name(@Nullable String var1);

    public ConnectionBuilder credentials(@Nullable Credentials var1);

    default public ConnectionBuilder credentialsFromJson(JsonObject jsonObject) {
        return this.credentials(Credentials.fromJson(jsonObject));
    }

    public ConnectionBuilder trustedCertificates(@Nullable String var1);

    public ConnectionBuilder uri(String var1);

    public ConnectionBuilder connectionStatus(ConnectivityStatus var1);

    public ConnectionBuilder failoverEnabled(boolean var1);

    public ConnectionBuilder validateCertificate(boolean var1);

    public ConnectionBuilder processorPoolSize(int var1);

    public ConnectionBuilder sources(List<Source> var1);

    public ConnectionBuilder targets(List<Target> var1);

    public ConnectionBuilder setSources(List<Source> var1);

    public ConnectionBuilder setTargets(List<Target> var1);

    public ConnectionBuilder clientCount(int var1);

    public ConnectionBuilder specificConfig(Map<String, String> var1);

    public ConnectionBuilder mappingContext(@Nullable MappingContext var1);

    public ConnectionBuilder tags(Collection<String> var1);

    public ConnectionBuilder tag(String var1);

    public ConnectionBuilder lifecycle(@Nullable ConnectionLifecycle var1);

    public ConnectionBuilder sshTunnel(@Nullable SshTunnel var1);

    public ConnectionBuilder payloadMappingDefinition(PayloadMappingDefinition var1);

    public Connection build();
}

