/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.connectivity.ConnectionBuilder;
import org.eclipse.ditto.model.connectivity.ConnectionId;
import org.eclipse.ditto.model.connectivity.ConnectionLifecycle;
import org.eclipse.ditto.model.connectivity.ConnectionType;
import org.eclipse.ditto.model.connectivity.ConnectivityModelFactory;
import org.eclipse.ditto.model.connectivity.ConnectivityStatus;
import org.eclipse.ditto.model.connectivity.Credentials;
import org.eclipse.ditto.model.connectivity.PayloadMappingDefinition;
import org.eclipse.ditto.model.connectivity.Source;
import org.eclipse.ditto.model.connectivity.SshTunnel;
import org.eclipse.ditto.model.connectivity.Target;

@Immutable
public interface Connection
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public ConnectionId getId();

    public Optional<String> getName();

    public ConnectionType getConnectionType();

    public ConnectivityStatus getConnectionStatus();

    public List<Source> getSources();

    public List<Target> getTargets();

    public Optional<SshTunnel> getSshTunnel();

    public int getClientCount();

    public boolean isFailoverEnabled();

    public Optional<Credentials> getCredentials();

    public Optional<String> getTrustedCertificates();

    public String getUri();

    public String getProtocol();

    public Optional<String> getUsername();

    public Optional<String> getPassword();

    public String getHostname();

    public int getPort();

    public Optional<String> getPath();

    public boolean isValidateCertificates();

    public int getProcessorPoolSize();

    public Map<String, String> getSpecificConfig();

    public PayloadMappingDefinition getPayloadMappingDefinition();

    public Set<String> getTags();

    public Optional<ConnectionLifecycle> getLifecycle();

    default public boolean hasLifecycle(ConnectionLifecycle lifecycle) {
        return this.getLifecycle().filter(actualLifecycle -> Objects.equals(actualLifecycle, (Object)lifecycle)).isPresent();
    }

    default public ConnectionBuilder toBuilder() {
        return ConnectivityModelFactory.newConnectionBuilder(this);
    }

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.notHidden())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> LIFECYCLE = JsonFactory.newStringFieldDefinition((CharSequence)"__lifecycle", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> ID = JsonFactory.newStringFieldDefinition((CharSequence)"id", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> NAME = JsonFactory.newStringFieldDefinition((CharSequence)"name", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> CONNECTION_TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"connectionType", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> CONNECTION_STATUS = JsonFactory.newStringFieldDefinition((CharSequence)"connectionStatus", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> CREDENTIALS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"credentials", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> URI = JsonFactory.newStringFieldDefinition((CharSequence)"uri", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> SOURCES = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"sources", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> TARGETS = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"targets", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> SSH_TUNNEL = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"sshTunnel", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Integer> CLIENT_COUNT = JsonFactory.newIntFieldDefinition((CharSequence)"clientCount", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Boolean> FAILOVER_ENABLED = JsonFactory.newBooleanFieldDefinition((CharSequence)"failoverEnabled", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Boolean> VALIDATE_CERTIFICATES = JsonFactory.newBooleanFieldDefinition((CharSequence)"validateCertificates", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Integer> PROCESSOR_POOL_SIZE = JsonFactory.newIntFieldDefinition((CharSequence)"processorPoolSize", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> SPECIFIC_CONFIG = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"specificConfig", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        @Deprecated
        public static final JsonFieldDefinition<JsonObject> MAPPING_CONTEXT = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"mappingContext", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> MAPPING_DEFINITIONS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"mappingDefinitions", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> TAGS = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"tags", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> TRUSTED_CERTIFICATES = JsonFieldDefinition.ofString((CharSequence)"ca", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

