/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.connectivity.Credentials;
import org.eclipse.ditto.model.connectivity.CredentialsVisitor;

@Immutable
public final class ClientCertificateCredentials
implements Credentials {
    public static final String TYPE = "client-cert";
    @Nullable
    private final String clientCertificate;
    @Nullable
    private final String clientKey;

    private ClientCertificateCredentials(@Nullable String clientCertificate, @Nullable String clientKey) {
        this.clientCertificate = clientCertificate;
        this.clientKey = clientKey;
    }

    @Override
    public <T> T accept(CredentialsVisitor<T> visitor) {
        return visitor.clientCertificate(this);
    }

    public Optional<String> getClientCertificate() {
        return Optional.ofNullable(this.clientCertificate);
    }

    public Optional<String> getClientKey() {
        return Optional.ofNullable(this.clientKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCertificateCredentials that = (ClientCertificateCredentials)o;
        return Objects.equals(this.clientCertificate, that.clientCertificate) && Objects.equals(this.clientKey, that.clientKey);
    }

    public int hashCode() {
        return Objects.hash(this.clientCertificate, this.clientKey);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [clientCertificate=" + this.clientCertificate + ", clientKey=" + this.clientKey + "]";
    }

    @Override
    public JsonObject toJson() {
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(JsonFields.TYPE, (Object)TYPE);
        jsonObjectBuilder.set(JsonFields.CLIENT_CERTIFICATE, (Object)this.clientCertificate, Objects::nonNull);
        jsonObjectBuilder.set(JsonFields.CLIENT_KEY, (Object)this.clientKey, Objects::nonNull);
        return jsonObjectBuilder.build();
    }

    static ClientCertificateCredentials fromJson(JsonObject jsonObject) {
        Builder builder = ClientCertificateCredentials.newBuilder();
        jsonObject.getValue(JsonFields.CLIENT_CERTIFICATE).ifPresent(builder::clientCertificate);
        jsonObject.getValue(JsonFields.CLIENT_KEY).ifPresent(builder::clientKey);
        return builder.build();
    }

    public static ClientCertificateCredentials empty() {
        return ClientCertificateCredentials.newBuilder().build();
    }

    public Builder toBuilder() {
        return new Builder().clientCertificate(this.clientCertificate).clientKey(this.clientKey);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class JsonFields
    extends Credentials.JsonFields {
        public static final JsonFieldDefinition<String> CLIENT_CERTIFICATE = JsonFieldDefinition.ofString((CharSequence)"cert", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<String> CLIENT_KEY = JsonFieldDefinition.ofString((CharSequence)"key", (JsonFieldMarker[])new JsonFieldMarker[0]);
    }

    public static final class Builder {
        @Nullable
        private String clientCertificate;
        @Nullable
        private String clientKey;

        public Builder clientCertificate(@Nullable String clientCertificate) {
            this.clientCertificate = clientCertificate;
            return this;
        }

        public Builder clientKey(@Nullable String clientKey) {
            this.clientKey = clientKey;
            return this;
        }

        public ClientCertificateCredentials build() {
            return new ClientCertificateCredentials(this.clientCertificate, this.clientKey);
        }
    }
}

