/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryRenderingDialog;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddMemoryRenderingAction
extends AddMemoryBlockAction {
    private IMemoryRenderingContainer fContainer;
    static /* synthetic */ Class class$0;

    public AddMemoryRenderingAction(IMemoryRenderingContainer container) {
        super(DebugUIMessages.AddMemoryRenderingAction_Add_renderings, 1, container.getMemoryRenderingSite());
        this.setToolTipText(DebugUIMessages.AddMemoryRenderingAction_Add_renderings);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".AddRenderingContextAction_context");
        this.fContainer = container;
    }

    public void run() {
        Shell shell = DebugUIPlugin.getShell();
        IDebugElement elem = this.getDebugElement(this.fCurrentContext);
        if (elem != null) {
            IMemoryBlockRetrieval standardMemRetrieval;
            AddMemoryRenderingDialog dialog = new AddMemoryRenderingDialog(shell, this.fSite);
            dialog.open();
            Object[] renderings = dialog.getResult();
            IMemoryBlock blk = dialog.getMemoryBlock();
            if (blk == null) {
                return;
            }
            IDebugTarget debugTarget = elem.getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((standardMemRetrieval = (IMemoryBlockRetrieval)elem.getAdapter((Class)clazz)) == null) {
                standardMemRetrieval = debugTarget;
            }
            if (standardMemRetrieval == null) {
                return;
            }
            int i = 0;
            while (i < renderings.length) {
                if (renderings[i] instanceof IMemoryRenderingType) {
                    try {
                        IMemoryRendering rendering = ((IMemoryRenderingType)renderings[i]).createRendering();
                        if (rendering != null) {
                            rendering.init(this.fContainer, blk);
                            this.fContainer.addMemoryRendering(rendering);
                        }
                    }
                    catch (CoreException e) {
                        MemoryViewUtil.openError(DebugUIMessages.AddMemoryRenderingAction_Add_rendering_failed, DebugUIMessages.AddMemoryRenderingAction_Unable_to_add_selected_renderings, (Exception)((Object)e));
                    }
                }
                ++i;
            }
        }
    }

    private IDebugElement getDebugElement(Object elem) {
        if (!(elem instanceof IDebugElement)) {
            return null;
        }
        return (IDebugElement)elem;
    }
}

