# Notices for Eclipse Dataspace Connector

This content is produced and maintained by the Eclipse Dash, Tools for
Committers project.

* Project home: https://projects.eclipse.org/projects/technology.dataspaceconnector

## Trademarks

Eclipse Dataspace Connector and the Eclipse Dataspace Connector logo are trademarks of the Eclipse Foundation.
Eclipse and the Eclipse Logo are registered trademarks of the Eclipse Foundation.

## Copyright

All content is the property of the respective authors or their employers. For more information regarding authorship of content, please consult the listed source code repository logs.

## Declared Project Licenses

This program and the accompanying materials are made available under the terms of the Apache License, Version 2.0 which is available at https://www.apache.org/licenses/LICENSE-2.0.

SPDX-License-Identifier: Apache-2.0

## Source Code

The project maintains the following source code repositoriy:

* https://github.com/eclipse-dataspaceconnector/DataSpaceConnector

## Third-party Content (Overarching All Modules)

Atomikos Util
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/atomikos-util/5.0.8
* License: Apache-2.0

Atomikos Transactions API
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/transactions-api/5.0.8
* License: Apache-2.0

Atomikos Transactions JDBC
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/transactions-jdbc/5.0.8
* License: Apache-2.0

Atomikos Transactions JTA
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/transactions-jta/5.0.8
* License: Apache-2.0

Atomikos Transactions Core
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/transactions/5.0.8
* License: Apache-2.0

java jwt
* Project: https://github.com/auth0/java-jwt
* Source: scm:git@github.com:auth0/java-jwt.git
* Maven Artifact: com.auth0/java-jwt/3.13.0
* License: MIT

Microsoft Azure SDK for App Platform Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-appplatform/2.1.0
* License: MIT

Microsoft Azure SDK for App Service Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-appservice/2.1.0
* License: MIT

Microsoft Azure SDK for Authorization Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-authorization/2.1.0
* License: MIT

Microsoft Azure SDK for Authorization Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-authorization/2.2.0
* License: MIT

Microsoft Azure SDK for CDN Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-cdn/2.1.0
* License: MIT

Microsoft Azure SDK for Compute Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-compute/2.1.0
* License: MIT

Microsoft Azure SDK for Container Instance Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-containerinstance/2.1.0
* License: MIT

Microsoft Azure SDK for Container Registry Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-containerregistry/2.1.0
* License: MIT

Microsoft Azure SDK for Container Service Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-containerservice/2.1.0
* License: MIT

Microsoft Azure SDK for CosmosDB Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-cosmos/2.1.0
* License: MIT

Microsoft Azure SDK for DNS Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-dns/2.1.0
* License: MIT

Microsoft Azure SDK for EventHubs Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-eventhubs/2.1.0
* License: MIT

Microsoft Azure SDK for Key Vault Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-keyvault/2.1.0
* License: MIT

Microsoft Azure SDK for Key Vault Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-keyvault/2.2.0
* License: MIT

Microsoft Azure SDK for Monitor Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-monitor/2.1.0
* License: MIT

Microsoft Azure SDK for Managed Service Identity (MSI) Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-msi/2.1.0
* License: MIT

Microsoft Azure SDK for Network Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-network/2.1.0
* License: MIT

Microsoft Azure SDK for Private DNS Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-privatedns/2.1.0
* License: MIT

Microsoft Azure SDK for Redis Cache Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-redis/2.1.0
* License: MIT

Microsoft Azure SDK for Resource Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-resources/2.1.0
* License: MIT

Microsoft Azure SDK for Resource Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-resources/2.2.0
* License: MIT

Microsoft Azure SDK for ServiceBus Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-servicebus/2.1.0
* License: MIT

Microsoft Azure SDK for Sql Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-sql/2.1.0
* License: MIT

Microsoft Azure SDK for Storage Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-storage/2.1.0
* License: MIT

Microsoft Azure SDK for Traffic Manager Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-trafficmanager/2.1.0
* License: MIT

Microsoft Azure SDK for Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager/2.1.0
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.10.0
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.11.2
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.11.4
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.6.3
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.8.0
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.9.1
* License: MIT

Microsoft Azure Management Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-management/1.1.1
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.10.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.13.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.15.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.17.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.22.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.23.1
* License: MIT

Microsoft Azure SDK for SQL API of Azure Cosmos DB Service
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-cosmos/4.23.0
* License: MIT

Microsoft Azure client library for Identity
* Project: https://github.com/Azure/azure-sdk-for-java
* Maven Artifact: com.azure/azure-identity/1.2.0
* License: MIT

Microsoft Azure client library for Identity
* Project: https://github.com/Azure/azure-sdk-for-java
* Maven Artifact: com.azure/azure-identity/1.2.5
* License: MIT

Microsoft Azure SDK for eventgrid
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-messaging-eventgrid/4.4.0
* License: MIT

Microsoft Azure client library for KeyVault Keys
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-security-keyvault-keys/4.2.5
* License: MIT

Microsoft Azure client library for KeyVault Secrets
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-security-keyvault-secrets/4.2.3
* License: MIT

Microsoft Azure client library for KeyVault Secrets
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-security-keyvault-secrets/4.2.5
* License: MIT

Microsoft Azure client library for Blob Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-blob/12.14.2
* License: MIT

Microsoft Azure common module for Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-common/12.14.1
* License: MIT

Microsoft Azure common module for Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-common/12.9.0
* License: MIT

Microsoft Azure client library for File Share Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-file-share/12.7.0
* License: MIT

Microsoft Azure internal Avro module for Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-internal-avro/12.1.2
* License: MIT

Microsoft Azure Java Client Runtime For AutoRest
* Project: https://github.com/Azure/autorest-clientruntime-for-java
* Source: scm:git:https://github.com/Azure/autorest-clientruntime-for-java
* Maven Artifact: com.microsoft.azure/azure-client-runtime/1.7.14
* License: MIT

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.11.2
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.12.1
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.12.2
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.12.3
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.12.5
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.13.0
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.13.1
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.12.1
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.12.2
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.12.3
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.12.5
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.13.0
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.13.1
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.10.1
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.11.0
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.12.1
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.12.2
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.12.3
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.12.5
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.13.0
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.13.1
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.9.8
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.11.2
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.12.2
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.12.3
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.12.5
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.13.0
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.13.1
* License: Apache-2.0

Jackson-dataformat-YAML
* Project: https://github.com/FasterXML/jackson-dataformats-text
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-yaml/2.12.1
* License: Apache-2.0

Jackson-dataformat-YAML
* Project: https://github.com/FasterXML/jackson-dataformats-text
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-yaml/2.13.1
* License: Apache-2.0

Jackson-datatype-Joda
* Project: http://wiki.fasterxml.com/JacksonModuleJoda
* Source: scm:git:git@github.com:FasterXML/jackson-datatype-joda.git
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-joda/2.10.5
* License: Apache-2.0

Jackson datatype: Joda
* Project: https://github.com/FasterXML/jackson-datatype-joda
* Source: scm:git:git@github.com:FasterXML/jackson-datatype-joda.git
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-joda/2.13.1
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.11.2
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.12.1
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.12.2
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.12.3
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.12.5
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.13.0
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.13.1
* License: Apache-2.0

Jackson module: Afterburner
* Project: https://github.com/FasterXML/jackson-modules-base
* Maven Artifact: com.fasterxml.jackson.module/jackson-module-afterburner/2.12.5
* License: Apache-2.0

Jackson module: Afterburner
* Project: https://github.com/FasterXML/jackson-modules-base
* Maven Artifact: com.fasterxml.jackson.module/jackson-module-afterburner/2.13.1
* License: Apache-2.0

Jackson module: JAXB Annotations
* Project: https://github.com/FasterXML/jackson-modules-base
* Maven Artifact: com.fasterxml.jackson.module/jackson-module-jaxb-annotations/2.12.2
* License: Apache-2.0

Jackson module: Old JAXB Annotations (javax.xml.bind)
* Project: https://github.com/FasterXML/jackson-modules-base
* Maven Artifact: com.fasterxml.jackson.module/jackson-module-jaxb-annotations/2.13.1
* License: Apache-2.0

Jackson BOM
* Project: https://github.com/FasterXML/jackson-bom
* Source: scm:git:git@github.com:FasterXML/jackson-bom.git
* Maven Artifact: com.fasterxml.jackson/jackson-bom/2.12.1
* License: Apache-2.0

Jackson BOM
* Project: https://github.com/FasterXML/jackson-bom
* Source: scm:git:git@github.com:FasterXML/jackson-bom.git
* Maven Artifact: com.fasterxml.jackson/jackson-bom/2.13.1
* License:

Woodstox
* Project: https://github.com/FasterXML/woodstox
* Source: scm:git:git@github.com:FasterXML/woodstox.git
* Maven Artifact: com.fasterxml.woodstox/woodstox-core/6.2.7
* License: Apache-2.0

aalto-xml
* Source: scm:git:git@github.com:FasterXML/aalto-xml.git
* Maven Artifact: com.fasterxml/aalto-xml/1.0.0
* License: Apache-2.0

Java Faker
* Project: http://github.com/DiUS/java-faker
* Source: scm:git:git://github.com/DiUS/java-faker.git
* Maven Artifact: com.github.javafaker/javafaker/1.0.2
* License: Apache-2.0

Generex
* Project: https://github.com/mifmif/Generex/tree/master
* Source: scm:git:git@github.com:mifmif/Generex.git
* Maven Artifact: com.github.mifmif/generex/1.0.2
* License: Apache-2.0

JCIP Annotations under Apache License
* Project: http://stephenc.github.com/jcip-annotations
* Source: scm:git:git://github.com/stephenc/jcip-annotations.git
* Maven Artifact: com.github.stephenc.jcip/jcip-annotations/1.0-1
* License: Apache-2.0

FindBugs-jsr305
* Project: http://findbugs.sourceforge.net/
* Source: scm:git:https://code.google.com/p/jsr-305/
* Maven Artifact: com.google.code.findbugs/jsr305/3.0.2
* License: Apache-2.0

Gson
* Maven Artifact: com.google.code.gson/gson/2.8.6
* License: Apache-2.0

Tink Cryptography API
* Project: http://github.com/google/tink
* Source: scm:git:git@github.com:google/tink.git
* Maven Artifact: com.google.crypto.tink/tink/1.6.1
* License: Apache-2.0

error-prone annotations
* Maven Artifact: com.google.errorprone/error_prone_annotations/2.5.1
* License: Apache-2.0

Guava InternalFutureFailureAccess and InternalFutures
* Maven Artifact: com.google.guava/failureaccess/1.0.1
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Maven Artifact: com.google.guava/guava/19.0
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Maven Artifact: com.google.guava/guava/20.0
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Maven Artifact: com.google.guava/guava/30.1.1-jre
* License: Apache-2.0

Guava ListenableFuture only
* Maven Artifact: com.google.guava/listenablefuture/9999.0-empty-to-avoid-conflict-with-guava
* License: NONE

J2ObjC Annotations
* Project: https://github.com/google/j2objc/
* Maven Artifact: com.google.j2objc/j2objc-annotations/1.3
* License: Apache-2.0

Protocol Buffers Core
* Maven Artifact: com.google.protobuf/protobuf-java/3.14.0
* License: BSD-3-Clause

H2 Database Engine
* Project: https://h2database.com
* Source: scm:git:https://github.com/h2database/h2database
* Maven Artifact: com.h2database/h2/2.1.210
* License: MPL-2.0

project ':json-path'
* Project: https://github.com/jayway/JsonPath
* Source: scm:git:git://github.com/jayway/JsonPath.git
* Maven Artifact: com.jayway.jsonpath/json-path/2.4.0
* License: Apache-2.0

Spongy Castle
* Project: http://rtyley.github.io/spongycastle/
* Source: scm:git@github.com:rtyley/spongycastle.git
* Maven Artifact: com.madgag.spongycastle/core/1.54.0.0
* License: MIT

c3p0
* Project: https://github.com/swaldman/c3p0
* Source: scm:git:git@github.com:swaldman/c3p0.git
* Maven Artifact: com.mchange/c3p0/0.9.5.2
* License: EPL-1.0

mchange-commons-java
* Project: https://github.com/swaldman/mchange-commons-java
* Source: scm:git:git@github.com:swaldman/mchange-commons-java.git
* Maven Artifact: com.mchange/mchange-commons-java/0.2.11
* License: EPL-1.0

Microsoft Azure SDK annotations
* Project: https://github.com/Microsoft/java-api-annotations
* Source: scm:git:git@github.com:Microsoft/java-api-annotations.git
* Maven Artifact: com.microsoft.azure/azure-annotations/1.10.0
* License: MIT

Microsoft Azure SDK annotations
* Project: https://github.com/Microsoft/java-api-annotations
* Source: scm:git:git@github.com:Microsoft/java-api-annotations.git
* Maven Artifact: com.microsoft.azure/azure-annotations/1.3.0
* License: MIT

Microsoft Azure SDK for Resource Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.microsoft.azure/azure-mgmt-resources/1.3.0
* License: MIT

msal4j-persistence-extension
* Project: https://github.com/AzureAD/microsoft-authentication-extensions-for-java
* Maven Artifact: com.microsoft.azure/msal4j-persistence-extension/1.0.0
* License: MIT

msal4j-persistence-extension
* Project: https://github.com/AzureAD/microsoft-authentication-extensions-for-java
* Maven Artifact: com.microsoft.azure/msal4j-persistence-extension/1.1.0
* License: MIT

msal4j
* Project: https://github.com/AzureAD/microsoft-authentication-library-for-java
* Maven Artifact: com.microsoft.azure/msal4j/1.4.0
* License: MIT

msal4j
* Project: https://github.com/AzureAD/microsoft-authentication-library-for-java
* Maven Artifact: com.microsoft.azure/msal4j/1.8.0
* License: MIT

msal4j
* Project: https://github.com/AzureAD/microsoft-authentication-library-for-java
* Maven Artifact: com.microsoft.azure/msal4j/1.9.1
* License: MIT

Java Client Runtime for AutoRest
* Project: https://github.com/Azure/autorest-clientruntime-for-java
* Source: scm:git:git@github.com:Azure/autorest-clientruntime-for-java.git
* Maven Artifact: com.microsoft.rest/client-runtime/1.7.14
* License: MIT

Nimbus Content Type
* Project: https://bitbucket.org/connect2id/nimbus-content-type
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-content-type.git
* Maven Artifact: com.nimbusds/content-type/2.0
* License: Apache-2.0

Nimbus Content Type
* Project: https://bitbucket.org/connect2id/nimbus-content-type
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-content-type.git
* Maven Artifact: com.nimbusds/content-type/2.1
* License: Apache-2.0

Nimbus LangTag
* Project: https://bitbucket.org/connect2id/nimbus-language-tags
* Source:  scm:git:https://bitbucket.org/connect2id/nimbus-language-tags.git
* Maven Artifact: com.nimbusds/lang-tag/1.4.4
* License: Apache-2.0

Nimbus JOSE+JWT
* Project: https://bitbucket.org/connect2id/nimbus-jose-jwt
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-jose-jwt.git
* Maven Artifact: com.nimbusds/nimbus-jose-jwt/8.14.1
* License: Apache-2.0

Nimbus JOSE+JWT
* Project: https://bitbucket.org/connect2id/nimbus-jose-jwt
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-jose-jwt.git
* Maven Artifact: com.nimbusds/nimbus-jose-jwt/8.20.1
* License: Apache-2.0

Nimbus JOSE+JWT
* Project: https://bitbucket.org/connect2id/nimbus-jose-jwt
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-jose-jwt.git
* Maven Artifact: com.nimbusds/nimbus-jose-jwt/8.22.1
* License: Apache-2.0

OAuth 2.0 SDK with OpenID Connect extensions
* Project: https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions
* Source: scm:git:https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions.git
* Maven Artifact: com.nimbusds/oauth2-oidc-sdk/7.1.1
* License: Apache-2.0

OAuth 2.0 SDK with OpenID Connect extensions
* Project: https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions
* Source: scm:git:https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions.git
* Maven Artifact: com.nimbusds/oauth2-oidc-sdk/7.4
* License: Apache-2.0

OAuth 2.0 SDK with OpenID Connect extensions
* Project: https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions
* Source: scm:git:https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions.git
* Maven Artifact: com.nimbusds/oauth2-oidc-sdk/8.23.1
* License: Apache-2.0

OAuth 2.0 SDK with OpenID Connect extensions
* Project: https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions
* Source: scm:git:https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions.git
* Maven Artifact: com.nimbusds/oauth2-oidc-sdk/8.36
* License: Apache-2.0

checkstyle
* Project: https://checkstyle.org/
* Source: scm:git:git@github.com:checkstyle/checkstyle.git
* Maven Artifact: com.puppycrawl.tools/checkstyle/9.0
* License: Apache-2.0

OkHttp Logging Interceptor
* Maven Artifact: com.squareup.okhttp3/logging-interceptor/3.12.12
* License: Apache-2.0

okhttp-dnsoverhttps
* Project: https://square.github.io/okhttp/
* Source: scm:git:https://github.com/square/okhttp.git
* Maven Artifact: com.squareup.okhttp3/okhttp-dnsoverhttps/4.9.3
* License: Apache-2.0

OkHttp URLConnection
* Maven Artifact: com.squareup.okhttp3/okhttp-urlconnection/3.12.12
* License: Apache-2.0

OkHttp
* Maven Artifact: com.squareup.okhttp3/okhttp/3.12.0
* License: Apache-2.0

OkHttp
* Maven Artifact: com.squareup.okhttp3/okhttp/3.12.12
* License: Apache-2.0

okhttp
* Project: https://square.github.io/okhttp/
* Source: scm:git:https://github.com/square/okhttp.git
* Maven Artifact: com.squareup.okhttp3/okhttp/4.9.3
* License: Apache-2.0

Okio
* Maven Artifact: com.squareup.okio/okio/1.15.0
* License: Apache-2.0

Okio
* Project: https://github.com/square/okio/
* Source: scm:git:git://github.com/square/okio.git
* Maven Artifact: com.squareup.okio/okio/2.8.0
* License: Apache-2.0

Adapter: RxJava
* Maven Artifact: com.squareup.retrofit2/adapter-rxjava/2.6.4
* License: Apache-2.0

Converter: Jackson
* Maven Artifact: com.squareup.retrofit2/converter-jackson/2.6.4
* License: Apache-2.0

Retrofit
* Maven Artifact: com.squareup.retrofit2/retrofit/2.6.4
* License: Apache-2.0

Jakarta Activation
* Maven Artifact: com.sun.activation/jakarta.activation/2.0.0
* License: EPL-2.0

JavaMail API
* Maven Artifact: com.sun.mail/javax.mail/1.6.1
* License: CDDL

Old JAXB Runtime
* Maven Artifact: com.sun.xml.bind/jaxb-impl/2.3.3
* License: BSD-3-Clause

Netty Reactive Streams HTTP support
* Maven Artifact: com.typesafe.netty/netty-reactive-streams-http/2.0.4
* License: Apache-2.0

Netty Reactive Streams Implementation
* Maven Artifact: com.typesafe.netty/netty-reactive-streams/2.0.4
* License: Apache-2.0

HikariCP-java6
* Project: https://github.com/brettwooldridge/HikariCP
* Source: scm:git:git@github.com:brettwooldridge/HikariCP.git
* Maven Artifact: com.zaxxer/HikariCP-java6/2.3.13
* License: Apache-2.0

Apache Commons BeanUtils
* Project: https://commons.apache.org/proper/commons-beanutils/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/beanutils/tags/BEANUTILS_1_9_3_RC3
* Maven Artifact: commons-beanutils/commons-beanutils/1.9.4
* License: Apache-2.0

Apache Commons Codec
* Project: http://commons.apache.org/proper/commons-codec/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/codec/trunk
* Maven Artifact: commons-codec/commons-codec/1.10
* License: Apache-2.0

Apache Commons Codec
* Project: http://commons.apache.org/proper/commons-codec/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/codec/trunk
* Maven Artifact: commons-codec/commons-codec/1.11
* License: Apache-2.0

Apache Commons Codec
* Project: https://commons.apache.org/proper/commons-codec/
* Source: scm:git:https://gitbox.apache.org/repos/asf?p=commons-codec.git
* Maven Artifact: commons-codec/commons-codec/1.14
* License: Apache-2.0

Apache Commons Collections
* Project: http://commons.apache.org/collections/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/collections/trunk
* Maven Artifact: commons-collections/commons-collections/3.2.2
* License: Apache-2.0

Apache Commons Logging
* Project: http://commons.apache.org/proper/commons-logging/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/logging/trunk
* Maven Artifact: commons-logging/commons-logging/1.2
* License: Apache-2.0

Automaton
* Project: http://www.brics.dk/automaton/
* Maven Artifact: dk.brics.automaton/automaton/1.11-8
* License: BSD-2-Clause

picocli - a mighty tiny Command Line Interface
* Project: http://picocli.info
* Source: scm:git:https://github.com/remkop/picocli.git
* Maven Artifact: info.picocli/picocli/4.6.1
* License: Apache-2.0

picocli
* Project: http://picocli.info
* Source: scm:git:https://github.com/remkop/picocli.git
* Maven Artifact: info.picocli/picocli/4.6.2
* License: Apache-2.0

Metrics Core
* Maven Artifact: io.dropwizard.metrics/metrics-core/4.1.0
* License: Apache-2.0

ClassGraph
* Project: https://github.com/classgraph/classgraph
* Source: scm:git:git@github.com:classgraph/classgraph.git
* Maven Artifact: io.github.classgraph/classgraph/4.8.117
* License: MIT

ClassGraph
* Project: https://github.com/classgraph/classgraph
* Source: scm:git:git@github.com:classgraph/classgraph.git
* Maven Artifact: io.github.classgraph/classgraph/4.8.95
* License: MIT

java-json-canonicalization
* Project: https://github.com/erdtman/java-json-canonicalization
* Maven Artifact: io.github.erdtman/java-json-canonicalization/1.1
* License: Apache-2.0

ToolFactory JVM Driver
* Project: https://toolfactory.github.io/jvm-driver/
* Source: scm:git:${repository.url}
* Maven Artifact: io.github.toolfactory/jvm-driver/4.0.0
* License: MIT

Narcissus
* Project: https://github.com/toolfactory/narcissus
* Source: scm:git:https://toolfactory@github.com/toolfactory/narcissus.git
* Maven Artifact: io.github.toolfactory/narcissus/1.0.1
* License: MIT

micrometer-core
* Project: https://github.com/micrometer-metrics/micrometer
* Maven Artifact: io.micrometer/micrometer-core/1.8.0
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.52.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.59.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.60.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.63.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.65.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.68.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.70.Final
* License: Apache-2.0

Netty/Codec/DNS
* Maven Artifact: io.netty/netty-codec-dns/4.1.59.Final
* License: Apache-2.0

Netty/Codec/DNS
* Maven Artifact: io.netty/netty-codec-dns/4.1.63.Final
* License: Apache-2.0

Netty/Codec/DNS
* Maven Artifact: io.netty/netty-codec-dns/4.1.68.Final
* License: Apache-2.0

Netty/Codec/DNS
* Maven Artifact: io.netty/netty-codec-dns/4.1.70.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.43.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.52.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.59.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.60.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.63.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.65.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.68.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.70.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.52.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.59.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.60.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.63.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.65.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.68.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.70.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.52.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.60.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.65.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.68.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.70.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.52.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.59.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.60.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.63.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.65.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.68.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.70.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.52.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.59.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.60.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.63.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.65.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.68.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.70.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.52.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.59.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.60.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.63.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.65.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.68.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.70.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.43.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.52.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.59.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.60.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.63.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.65.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.68.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.70.Final
* License: Apache-2.0

Netty/Resolver/DNS/Classes/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-classes-macos/4.1.70.Final
* License: Apache-2.0

Netty/Resolver/DNS/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-native-macos/4.1.59.Final
* License: Apache-2.0

Netty/Resolver/DNS/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-native-macos/4.1.63.Final
* License: Apache-2.0

Netty/Resolver/DNS/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-native-macos/4.1.68.Final
* License: Apache-2.0

Netty/Resolver/DNS/Native/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-native-macos/4.1.70.Final
* License: Apache-2.0

Netty/Resolver/DNS
* Maven Artifact: io.netty/netty-resolver-dns/4.1.59.Final
* License: Apache-2.0

Netty/Resolver/DNS
* Maven Artifact: io.netty/netty-resolver-dns/4.1.63.Final
* License: Apache-2.0

Netty/Resolver/DNS
* Maven Artifact: io.netty/netty-resolver-dns/4.1.68.Final
* License: Apache-2.0

Netty/Resolver/DNS
* Maven Artifact: io.netty/netty-resolver-dns/4.1.70.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.52.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.59.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.60.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.63.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.65.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.68.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.70.Final
* License: Apache-2.0

Netty/TomcatNative [BoringSSL - Static]
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.34.Final
* License: Apache-2.0

Netty/TomcatNative [BoringSSL - Static]
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.36.Final
* License: Apache-2.0

Netty/TomcatNative [BoringSSL - Static]
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.39.Final
* License: Apache-2.0

Netty/TomcatNative [BoringSSL - Static]
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.43.Final
* License: Apache-2.0

Netty/TomcatNative [BoringSSL - Static]
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.46.Final
* License: Apache-2.0

Netty/TomcatNative [OpenSSL - Classes]
* Maven Artifact: io.netty/netty-tcnative-classes/2.0.46.Final
* License: Apache-2.0

Netty/Transport/Classes/Epoll
* Maven Artifact: io.netty/netty-transport-classes-epoll/4.1.70.Final
* License: Apache-2.0

Netty/Transport/Classes/KQueue
* Maven Artifact: io.netty/netty-transport-classes-kqueue/4.1.70.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.52.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.59.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.60.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.63.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.65.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.68.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.70.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.52.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.60.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.65.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.68.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.70.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.52.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.59.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.60.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.63.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.65.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.68.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.70.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.52.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.59.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.60.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.63.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.65.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.68.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.70.Final
* License: Apache-2.0

OpenTelemetry Java
* Project: https://github.com/open-telemetry/opentelemetry-java
* Source: scm:git:git@github.com:open-telemetry/opentelemetry-java.git
* Maven Artifact: io.opentelemetry/opentelemetry-api/1.11.0
* License: Apache-2.0

OpenTelemetry Java
* Project: https://github.com/open-telemetry/opentelemetry-java
* Source: scm:git:git@github.com:open-telemetry/opentelemetry-java.git
* Maven Artifact: io.opentelemetry/opentelemetry-context/1.11.0
* License: Apache-2.0

OpenTelemetry Java
* Project: https://github.com/open-telemetry/opentelemetry-java
* Source: scm:git:git@github.com:open-telemetry/opentelemetry-java.git
* Maven Artifact: io.opentelemetry/opentelemetry-extension-annotations/1.11.0
* License: Apache-2.0

Core functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-core/1.0.11
* License: Apache-2.0

Core functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-core/1.0.13
* License: Apache-2.0

Core functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-core/1.0.4
* License: Apache-2.0

Core functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-core/1.0.7
* License: Apache-2.0

Brave instrumentation for Reactor Netty HTTP
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http-brave/1.0.4
* License: Apache-2.0

Brave instrumentation for Reactor Netty HTTP
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http-brave/1.0.7
* License: Apache-2.0

HTTP functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http/1.0.11
* License: Apache-2.0

HTTP functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http/1.0.13
* License: Apache-2.0

HTTP functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http/1.0.4
* License: Apache-2.0

HTTP functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http/1.0.7
* License: Apache-2.0

Reactive Streams Netty driver
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty/0.9.12.RELEASE
* License: Apache-2.0

Reactor Netty with all modules
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty/1.0.4
* License: Apache-2.0

Reactor Netty with all modules
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty/1.0.7
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.3.10.RELEASE
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.4.10
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.4.12
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.4.3
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.4.6
* License: Apache-2.0

rxjava
* Project: https://github.com/ReactiveX/RxJava
* Maven Artifact: io.reactivex/rxjava/1.2.4
* License: Apache-2.0

rxjava
* Project: https://github.com/ReactiveX/RxJava
* Maven Artifact: io.reactivex/rxjava/1.3.0
* License: Apache-2.0

rxjava
* Project: https://github.com/ReactiveX/RxJava
* Maven Artifact: io.reactivex/rxjava/1.3.8
* License: Apache-2.0

json-path
* Project: http://maven.apache.org
* Maven Artifact: io.rest-assured/json-path/4.4.0
* License: Apache-2.0

json-path
* Project: http://maven.apache.org
* Maven Artifact: io.rest-assured/json-path/4.5.0
* License: Apache-2.0

rest-assured-common
* Project: http://maven.apache.org
* Maven Artifact: io.rest-assured/rest-assured-common/4.4.0
* License: Apache-2.0

rest-assured-common
* Project: http://maven.apache.org
* Maven Artifact: io.rest-assured/rest-assured-common/4.5.0
* License: Apache-2.0

REST Assured
* Project: http://code.google.com/p/rest-assured
* Maven Artifact: io.rest-assured/rest-assured/4.4.0
* License: Apache-2.0

REST Assured
* Project: http://code.google.com/p/rest-assured
* Maven Artifact: io.rest-assured/rest-assured/4.5.0
* License: Apache-2.0

Swagger Annotations Jakarta
* Maven Artifact: io.swagger.core.v3/swagger-annotations-jakarta/2.1.11
* License: Apache-2.0

Swagger Annotations
* Maven Artifact: io.swagger.core.v3/swagger-annotations/2.1.12
* License: Apache-2.0

Swagger Core Jakarta
* Maven Artifact: io.swagger.core.v3/swagger-core-jakarta/2.1.11
* License: Apache-2.0

Swagger Core
* Maven Artifact: io.swagger.core.v3/swagger-core/2.1.12
* License: Apache-2.0

Swagger Integration Jakarta
* Maven Artifact: io.swagger.core.v3/swagger-integration-jakarta/2.1.11
* License: Apache-2.0

Swagger Integration
* Maven Artifact: io.swagger.core.v3/swagger-integration/2.1.12
* License: Apache-2.0

Swagger JAXRS2 Jakarta
* Maven Artifact: io.swagger.core.v3/swagger-jaxrs2-jakarta/2.1.11
* License: Apache-2.0

Swagger JAXRS2
* Maven Artifact: io.swagger.core.v3/swagger-jaxrs2/2.1.12
* License: Apache-2.0

Swagger Models Jakarta
* Maven Artifact: io.swagger.core.v3/swagger-models-jakarta/2.1.11
* License: Apache-2.0

Swagger Models
* Maven Artifact: io.swagger.core.v3/swagger-models/2.1.12
* License: Apache-2.0

Brave Instrumentation: Http Adapters
* Maven Artifact: io.zipkin.brave/brave-instrumentation-http/5.13.3
* License: Apache-2.0

Brave
* Maven Artifact: io.zipkin.brave/brave/5.13.3
* License: Apache-2.0

Zipkin Reporter Brave
* Maven Artifact: io.zipkin.reporter2/zipkin-reporter-brave/2.16.3
* License: Apache-2.0

Zipkin Reporter: Core
* Maven Artifact: io.zipkin.reporter2/zipkin-reporter/2.16.3
* License: Apache-2.0

Zipkin Core Library
* Maven Artifact: io.zipkin.zipkin2/zipkin/2.23.2
* License: Apache-2.0

JavaBeans Activation Framework API jar
* Maven Artifact: jakarta.activation/jakarta.activation-api/1.2.1
* License: EPL-2.0

Jakarta Annotations API
* Project: https://projects.eclipse.org/projects/ee4j.ca
* Source: scm:git:https://github.com/eclipse-ee4j/common-annotations-api.git
* Maven Artifact: jakarta.annotation/jakarta.annotation-api/2.0.0
* License: EPL-2.0

Jakarta Dependency Injection
* Project: https://github.com/eclipse-ee4j/injection-api
* Source: scm:git:ssh://git@github.com/eclipse-ee4j/injection-api.git
* Maven Artifact: jakarta.inject/jakarta.inject-api/2.0.0
* License: Apache-2.0

${extension.name} API
* Project: https://projects.eclipse.org/projects/ee4j.jta
* Source: scm:git:https://github.com/eclipse-ee4j/jta-api.git
* Maven Artifact: jakarta.transaction/jakarta.transaction-api/2.0.0
* License: EPL-1.0

Jakarta Bean Validation API
* Project: https://beanvalidation.org
* Source: scm:git:git://github.com/eclipse-ee4j/beanvalidation-api.git
* Maven Artifact: jakarta.validation/jakarta.validation-api/2.0.2
* License: EPL-1.0

Jakarta Bean Validation API
* Project: https://beanvalidation.org
* Source: scm:git:git://github.com/eclipse-ee4j/beanvalidation-api.git
* Maven Artifact: jakarta.validation/jakarta.validation-api/3.0.0
* License: EPL-1.0

Jakarta WebSocket - Server API
* Project: https://projects.eclipse.org/projects/ee4j.websocket
* Maven Artifact: jakarta.websocket/jakarta.websocket-api/2.0.0
* License: EPL-2.0

jakarta.ws.rs-api
* Project: https://github.com/eclipse-ee4j/jaxrs-api
* Source: scm:git:https://github.com/eclipse-ee4j/jaxrs-api
* Maven Artifact: jakarta.ws.rs/jakarta.ws.rs-api/3.0.0
* License: EPL-2.0

Jakarta XML Binding API
* Maven Artifact: jakarta.xml.bind/jakarta.xml.bind-api/2.3.3
* License: BSD-3-Clause

Jakarta XML Binding API
* Maven Artifact: jakarta.xml.bind/jakarta.xml.bind-api/3.0.0
* License: BSD-3-Clause

JavaBeans Activation Framework (JAF)
* Project: http://java.sun.com/products/javabeans/jaf/index.jsp
* Maven Artifact: javax.activation/activation/1.1
* License: CDDL-1.0

JavaBeans Activation Framework API jar
* Maven Artifact: javax.activation/javax.activation-api/1.2.0
* License: CDDL-1.0

Java Servlet API
* Project: http://servlet-spec.java.net
* Source: scm:svn:https://svn.java.net/svn/glassfish~svn/tags/javax.servlet-api-3.1.0
* Maven Artifact: javax.servlet/javax.servlet-api/3.1.0
* License: CDDL-1.0

Javax Transaction API
* Project: http://jta-spec.java.net
* Source: scm:git:https://github.com/javaee/javax.transaction.git
* Maven Artifact: javax.transaction/javax.transaction-api/1.3
* License: CDDL-1.0

Bean Validation API
* Project: http://beanvalidation.org
* Source: scm:git:git://github.com/beanvalidation/beanvalidation-api.git
* Maven Artifact: javax.validation/validation-api/2.0.1.Final
* License: Apache-2.0

Javax WS RS API
* Project: http://jax-rs-spec.java.net
* Source: scm:git:https://github.com/jax-rs/api.git
* Maven Artifact: javax.ws.rs/javax.ws.rs-api/2.1
* License: CDDL-1.1

Joda-Time
* Project: https://www.joda.org/joda-time/
* Source: scm:git:https://github.com/JodaOrg/joda-time.git
* Maven Artifact: joda-time/joda-time/2.10.8
* License: Apache-2.0

Byte Buddy agent
* Maven Artifact: net.bytebuddy/byte-buddy-agent/1.12.4
* License: Apache-2.0

Byte Buddy (without dependencies)
* Maven Artifact: net.bytebuddy/byte-buddy/1.12.4
* License: Apache-2.0

Java Native Access Platform
* Project: https://github.com/java-native-access/jna
* Source: scm:git:https://github.com/java-native-access/jna
* Maven Artifact: net.java.dev.jna/jna-platform/5.5.0
* License: Apache-2.0

Java Native Access Platform
* Project: https://github.com/java-native-access/jna
* Source: scm:git:https://github.com/java-native-access/jna
* Maven Artifact: net.java.dev.jna/jna-platform/5.6.0
* License: Apache-2.0

Java Native Access
* Project: https://github.com/java-native-access/jna
* Source: scm:git:https://github.com/java-native-access/jna
* Maven Artifact: net.java.dev.jna/jna/5.5.0
* License: Apache-2.0

Java Native Access
* Project: https://github.com/java-native-access/jna
* Source: scm:git:https://github.com/java-native-access/jna
* Maven Artifact: net.java.dev.jna/jna/5.6.0
* License: Apache-2.0

Failsafe
* Project: https://failsafe-lib.github.io
* Source: scm:git:git@github.com:failsafe-lib/failsafe.git
* Maven Artifact: net.jodah/failsafe/2.4.3
* License: Apache-2.0

ASM based accessors helper used by json-smart
* Project: http://www.minidev.net/
* Source: scm:git:https://github.com/netplex/json-smart-v2.git
* Maven Artifact: net.minidev/accessors-smart/1.2
* License: Apache-2.0

ASM based accessors helper used by json-smart
* Project: https://urielch.github.io/
* Source: scm:git:https://github.com/netplex/json-smart-v2.git
* Maven Artifact: net.minidev/accessors-smart/2.4.7
* License: Apache-2.0

JSON Small and Fast Parser
* Project: http://www.minidev.net/
* Source: scm:git:https://github.com/netplex/json-smart-v2.git
* Maven Artifact: net.minidev/json-smart/2.3
* License: Apache-2.0

Saxon-HE
* Project: http://www.saxonica.com/
* Source: scm:svn:https://dev.saxonica.com/repos/archive/opensource/
* Maven Artifact: net.sf.saxon/Saxon-HE/10.5
* License: Apache-2.0

ANTLR 4 Runtime
* Maven Artifact: org.antlr/antlr4-runtime/4.9.2
* License: BSD-3-Clause

Apache Commons Lang
* Project: https://commons.apache.org/proper/commons-lang/
* Source: scm:git:http://gitbox.apache.org/repos/asf/commons-lang.git
* Maven Artifact: org.apache.commons/commons-lang3/3.11
* License: Apache-2.0

Apache Commons Lang
* Project: http://commons.apache.org/proper/commons-lang/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/lang/tags/LANG_3_4
* Maven Artifact: org.apache.commons/commons-lang3/3.4
* License: Apache-2.0

Apache Commons Lang
* Project: http://commons.apache.org/proper/commons-lang/
* Source: scm:git:http://git-wip-us.apache.org/repos/asf/commons-lang.git
* Maven Artifact: org.apache.commons/commons-lang3/3.5
* License: Apache-2.0

Apache Commons Lang
* Project: http://commons.apache.org/proper/commons-lang/
* Source: scm:git:http://git-wip-us.apache.org/repos/asf/commons-lang.git
* Maven Artifact: org.apache.commons/commons-lang3/3.7
* License: Apache-2.0

Apache Commons Pool
* Project: https://commons.apache.org/proper/commons-pool/
* Source: scm:git:https://gitbox.apache.org/repos/asf/commons-pool.git
* Maven Artifact: org.apache.commons/commons-pool2/2.11.1
* License: Apache-2.0

Apache HttpClient
* Project: http://hc.apache.org/httpcomponents-client
* Maven Artifact: org.apache.httpcomponents/httpclient/4.5.13
* License: Apache-2.0

Apache HttpCore
* Project: http://hc.apache.org/httpcomponents-core-ga
* Maven Artifact: org.apache.httpcomponents/httpcore/4.4.11
* License: Apache-2.0

Apache HttpCore
* Project: http://hc.apache.org/httpcomponents-core-ga
* Maven Artifact: org.apache.httpcomponents/httpcore/4.4.13
* License: Apache-2.0

Apache HttpCore
* Project: http://hc.apache.org/httpcomponents-core-ga
* Maven Artifact: org.apache.httpcomponents/httpcore/4.4.5
* License: Apache-2.0

Apache HttpClient Mime
* Project: http://hc.apache.org/httpcomponents-client
* Maven Artifact: org.apache.httpcomponents/httpmime/4.5.13
* License: Apache-2.0

org.apiguardian:apiguardian-api
* Project: https://github.com/apiguardian-team/apiguardian
* Source: scm:git:git://github.com/apiguardian-team/apiguardian.git
* Maven Artifact: org.apiguardian/apiguardian-api/1.1.2
* License: Apache-2.0

AssertJ fluent assertions
* Source: scm:git:git@github.com:assertj/assertj-core.git
* Maven Artifact: org.assertj/assertj-core/3.19.0
* License: Apache-2.0

AssertJ fluent assertions
* Source: scm:git:git@github.com:assertj/assertj-core.git
* Maven Artifact: org.assertj/assertj-core/3.20.2
* License: Apache-2.0

AssertJ fluent assertions
* Source: scm:git:git@github.com:assertj/assertj-core.git
* Maven Artifact: org.assertj/assertj-core/3.21.0
* License: Apache-2.0

AssertJ fluent assertions
* Source: scm:git:https://github.com/assertj/assertj-core.git
* Maven Artifact: org.assertj/assertj-core/3.22.0
* License: Apache-2.0

Awaitility
* Project: http://awaitility.org
* Maven Artifact: org.awaitility/awaitility/4.1.1
* License: Apache-2.0

Bouncy Castle PKIX, CMS, EAC, TSP, PKCS, OCSP, CMP, and CRMF APIs
* Project: http://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcpkix-jdk15on/1.56
* License: MIT

Bouncy Castle Provider
* Project: http://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcprov-jdk15on/1.56
* License: MIT

Bouncy Castle Provider
* Project: https://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcprov-jdk15on/1.69
* License: MIT

TagSoup
* Project: http://home.ccil.org/~cowan/XML/tagsoup/
* Maven Artifact: org.ccil.cowan.tagsoup/tagsoup/1.2.1
* License: Apache-2.0

Checker Qual
* Project: https://checkerframework.org
* Source: https://github.com/typetools/checker-framework.git
* Maven Artifact: org.checkerframework/checker-qual/3.8.0
* License: MIT

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy-json/3.0.8
* License: Apache-2.0

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy-json/3.0.9
* License: Apache-2.0

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy-xml/3.0.8
* License: Apache-2.0

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy-xml/3.0.9
* License: Apache-2.0

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy/3.0.8
* License: Apache-2.0

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy/3.0.9
* License: Apache-2.0

Stax2 API
* Project: http://github.com/FasterXML/stax2-api
* Source: scm:git:git@github.com:FasterXML/stax2-api.git
* Maven Artifact: org.codehaus.woodstox/stax2-api/4.0.0
* License: BSD-2-Clause

Stax2 API
* Project: http://github.com/FasterXML/stax2-api
* Source: scm:git:git@github.com:FasterXML/stax2-api.git
* Maven Artifact: org.codehaus.woodstox/stax2-api/4.2.1
* License: BSD-2-Clause

Jetty :: Jakarta Servlet API and Schemas for JPMS and OSGi
* Source: scm:git:https://github.com/eclipse/jetty.toolchain.git
* Maven Artifact: org.eclipse.jetty.toolchain/jetty-jakarta-servlet-api/5.0.2
* License: EPL-2.0

Jetty :: Jakarta WebSocket API for JPMS and OSGi
* Source: scm:git:https://github.com/eclipse/jetty.toolchain.git
* Maven Artifact: org.eclipse.jetty.toolchain/jetty-jakarta-websocket-api/2.0.0
* License: EPL-2.0

Jetty :: Websocket :: Core :: Client
* Maven Artifact: org.eclipse.jetty.websocket/websocket-core-client/11.0.6
* License: EPL-2.0

Jetty :: Websocket :: Core :: Common
* Maven Artifact: org.eclipse.jetty.websocket/websocket-core-common/11.0.6
* License: EPL-2.0

Jetty :: Websocket :: Core :: Server
* Maven Artifact: org.eclipse.jetty.websocket/websocket-core-server/11.0.6
* License: EPL-2.0

Jetty :: Websocket :: jakarta.websocket :: Client
* Maven Artifact: org.eclipse.jetty.websocket/websocket-jakarta-client/11.0.6
* License: EPL-2.0

Jetty :: Websocket :: jakarta.websocket :: Common
* Maven Artifact: org.eclipse.jetty.websocket/websocket-jakarta-common/11.0.6
* License: EPL-2.0

Jetty :: Websocket :: jakarta.websocket :: Server
* Maven Artifact: org.eclipse.jetty.websocket/websocket-jakarta-server/11.0.6
* License: EPL-2.0

Jetty :: Websocket :: Servlet
* Maven Artifact: org.eclipse.jetty.websocket/websocket-servlet/11.0.6
* License: EPL-2.0

Jetty :: ALPN :: Client
* Maven Artifact: org.eclipse.jetty/jetty-alpn-client/11.0.6
* License: EPL-2.0

Jetty :: Servlet Annotations
* Maven Artifact: org.eclipse.jetty/jetty-annotations/11.0.6
* License: EPL-2.0

Jetty :: Asynchronous HTTP Client
* Maven Artifact: org.eclipse.jetty/jetty-client/11.0.6
* License: EPL-2.0

Jetty :: Http Utility
* Maven Artifact: org.eclipse.jetty/jetty-http/11.0.6
* License: EPL-2.0

Jetty :: IO Utility
* Maven Artifact: org.eclipse.jetty/jetty-io/11.0.6
* License: EPL-2.0

Jetty :: JNDI Naming
* Maven Artifact: org.eclipse.jetty/jetty-jndi/11.0.6
* License: EPL-2.0

Jetty :: Plus
* Maven Artifact: org.eclipse.jetty/jetty-plus/11.0.6
* License: EPL-2.0

Jetty :: Security
* Maven Artifact: org.eclipse.jetty/jetty-security/11.0.6
* License: EPL-2.0

Jetty :: Server Core
* Maven Artifact: org.eclipse.jetty/jetty-server/11.0.6
* License: EPL-2.0

Jetty :: Servlet Handling
* Maven Artifact: org.eclipse.jetty/jetty-servlet/11.0.6
* License: EPL-2.0

Jetty :: Utilities
* Maven Artifact: org.eclipse.jetty/jetty-util/11.0.6
* License: EPL-2.0

Jetty :: Webapp Application Support
* Maven Artifact: org.eclipse.jetty/jetty-webapp/11.0.6
* License: EPL-2.0

Jetty :: XML utilities
* Maven Artifact: org.eclipse.jetty/jetty-xml/11.0.6
* License: EPL-2.0

aopalliance version ${aopalliance.version} repackaged as a module
* Maven Artifact: org.glassfish.hk2.external/aopalliance-repackaged/3.0.1
* License: EPL-2.0

HK2 API module
* Maven Artifact: org.glassfish.hk2/hk2-api/3.0.1
* License: EPL-2.0

ServiceLocator Default Implementation
* Maven Artifact: org.glassfish.hk2/hk2-locator/3.0.1
* License: EPL-2.0

HK2 Implementation Utilities
* Maven Artifact: org.glassfish.hk2/hk2-utils/3.0.1
* License: EPL-2.0

OSGi resource locator
* Source: scm:git:https://github.com/eclipse-ee4j/glassfish-hk2-extra.git
* Maven Artifact: org.glassfish.hk2/osgi-resource-locator/1.0.3
* License: CDDL-1.0

jersey-container-servlet-core
* Maven Artifact: org.glassfish.jersey.containers/jersey-container-servlet-core/3.0.3
* License: EPL-2.0

jersey-container-servlet
* Maven Artifact: org.glassfish.jersey.containers/jersey-container-servlet/3.0.3
* License: EPL-2.0

jersey-core-client
* Maven Artifact: org.glassfish.jersey.core/jersey-client/3.0.3
* License: EPL-2.0

jersey-core-common
* Maven Artifact: org.glassfish.jersey.core/jersey-common/3.0.3
* License: EPL-2.0

jersey-core-server
* Maven Artifact: org.glassfish.jersey.core/jersey-server/3.0.3
* License: EPL-2.0

jersey-ext-entity-filtering
* Maven Artifact: org.glassfish.jersey.ext/jersey-entity-filtering/3.0.3
* License: EPL-2.0

jersey-inject-hk2
* Maven Artifact: org.glassfish.jersey.inject/jersey-hk2/3.0.3
* License: EPL-2.0

jersey-media-json-jackson
* Maven Artifact: org.glassfish.jersey.media/jersey-media-json-jackson/3.0.3
* License: EPL-2.0

jersey-media-multipart
* Maven Artifact: org.glassfish.jersey.media/jersey-media-multipart/3.0.3
* License: EPL-2.0

Hamcrest Core
* Project: http://hamcrest.org/JavaHamcrest/
* Source: git@github.com:hamcrest/JavaHamcrest.git
* Maven Artifact: org.hamcrest/hamcrest-core/2.2
* License: BSD-3-Clause

Hamcrest
* Project: http://hamcrest.org/JavaHamcrest/
* Source: git@github.com:hamcrest/JavaHamcrest.git
* Maven Artifact: org.hamcrest/hamcrest/2.1
* License: BSD-3-Clause

Hamcrest
* Project: http://hamcrest.org/JavaHamcrest/
* Source: git@github.com:hamcrest/JavaHamcrest.git
* Maven Artifact: org.hamcrest/hamcrest/2.2
* License: BSD-3-Clause

HdrHistogram
* Project: http://hdrhistogram.github.io/HdrHistogram/
* Source: scm:git:git://github.com/HdrHistogram/HdrHistogram.git
* Maven Artifact: org.hdrhistogram/HdrHistogram/2.1.12
* License: BSD-2-Clause

JaCoCo :: Agent
* Maven Artifact: org.jacoco/org.jacoco.agent/0.8.7
* License: EPL-2.0

JaCoCo :: Ant
* Maven Artifact: org.jacoco/org.jacoco.ant/0.8.7
* License: EPL-2.0

JaCoCo :: Core
* Maven Artifact: org.jacoco/org.jacoco.core/0.8.7
* License: EPL-2.0

JaCoCo :: Report
* Maven Artifact: org.jacoco/org.jacoco.report/0.8.7
* License: EPL-2.0

Javassist
* Project: http://www.javassist.org/
* Source: scm:git:git@github.com:jboss-javassist/javassist.git
* Maven Artifact: org.javassist/javassist/3.25.0-GA
* License: MPL-1.1

Javassist
* Project: http://www.javassist.org/
* Source: scm:git:git@github.com:jboss-javassist/javassist.git
* Maven Artifact: org.javassist/javassist/3.26.0-GA
* License: MPL-1.1

org.jetbrains.kotlin:kotlin-stdlib-common
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-common/1.4.0
* License: Apache-2.0

org.jetbrains.kotlin:kotlin-stdlib-common
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-common/1.4.10
* License: Apache-2.0

org.jetbrains.kotlin:kotlin-stdlib-jdk7
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-jdk7/1.4.10
* License: Apache-2.0

org.jetbrains.kotlin:kotlin-stdlib-jdk8
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-jdk8/1.4.10
* License: Apache-2.0

org.jetbrains.kotlin:kotlin-stdlib
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib/1.4.0
* License: Apache-2.0

org.jetbrains.kotlin:kotlin-stdlib
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib/1.4.10
* License: Apache-2.0

IntelliJ IDEA Annotations
* Project: http://www.jetbrains.org
* Source: scm:git:https://github.com/JetBrains/intellij-community.git
* Maven Artifact: org.jetbrains/annotations/13.0
* License: Apache-2.0

IntelliJ IDEA Annotations
* Project: http://www.jetbrains.org
* Source: scm:git:https://github.com/JetBrains/intellij-community.git
* Maven Artifact: org.jetbrains/annotations/15.0
* License: Apache-2.0

JLine Bundle
* Maven Artifact: org.jline/jline/3.19.0
* License: BSD-3-Clause

JUnit Jupiter API
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-api/5.8.1
* License: EPL-2.0

JUnit Jupiter API
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-api/5.8.2
* License: EPL-2.0

JUnit Jupiter Engine
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-engine/5.8.1
* License: EPL-2.0

JUnit Jupiter Engine
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-engine/5.8.2
* License: EPL-2.0

JUnit Jupiter Params
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-params/5.8.1
* License: EPL-2.0

JUnit Jupiter Params
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-params/5.8.2
* License: EPL-2.0

JUnit Platform Commons
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.platform/junit-platform-commons/1.8.2
* License: EPL-2.0

JUnit Platform Engine API
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.platform/junit-platform-engine/1.8.2
* License: EPL-2.0

JUnit 5 (Bill of Materials)
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit/junit-bom/5.8.2
* License: EPL-2.0

MIME streaming extension
* Project: https://github.com/eclipse-ee4j/metro-mimepull
* Source: scm:git:ssh://git@github.com/eclipse-ee4j/metro-mimepull.git
* Maven Artifact: org.jvnet.mimepull/mimepull/1.9.13
* License: EDL 1.0

LatencyUtils
* Project: http://latencyutils.github.io/LatencyUtils/
* Source: scm:git:git://github.com/LatencyUtils/LatencyUtils.git
* Maven Artifact: org.latencyutils/LatencyUtils/2.0.3
* License: BSD-2-Clause

KeePassJava2 :: DOM
* Maven Artifact: org.linguafranca.pwdb/KeePassJava2-dom/2.1.4
* License: Apache-2.0

KeePassJava2 :: JAXB
* Maven Artifact: org.linguafranca.pwdb/KeePassJava2-jaxb/2.1.4
* License: Apache-2.0

KeePassJava2 :: KDB
* Maven Artifact: org.linguafranca.pwdb/KeePassJava2-kdb/2.1.4
* License: Apache-2.0

KeePassJava2 :: KDBX
* Maven Artifact: org.linguafranca.pwdb/KeePassJava2-kdbx/2.1.4
* License: Apache-2.0

KeePassJava2 :: Simple
* Maven Artifact: org.linguafranca.pwdb/KeePassJava2-simple/2.1.4
* License: Apache-2.0

KeePassJava2 :: All
* Maven Artifact: org.linguafranca.pwdb/KeePassJava2/2.1.4
* License: Apache-2.0

PWDB :: Database
* Maven Artifact: org.linguafranca.pwdb/database/2.1.4
* License: Apache-2.0

mockito-core
* Project: https://github.com/mockito/mockito
* Maven Artifact: org.mockito/mockito-core/4.2.0
* License: MIT

mockito-inline
* Project: https://github.com/mockito/mockito
* Maven Artifact: org.mockito/mockito-inline/4.2.0
* License: MIT

Objenesis
* Maven Artifact: org.objenesis/objenesis/3.2
* License: Apache-2.0

org.opentest4j:opentest4j
* Project: https://github.com/ota4j-team/opentest4j
* Source: scm:git:git://github.com/ota4j-team/opentest4j.git
* Maven Artifact: org.opentest4j/opentest4j/1.2.0
* License: Apache-2.0

asm-analysis
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm-analysis/9.1
* License: BSD-3-Clause

asm-commons
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm-commons/9.1
* License: BSD-3-Clause

asm-tree
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm-tree/9.1
* License: BSD-3-Clause

ASM Core
* Maven Artifact: org.ow2.asm/asm/5.0.4
* License: BSD-2-Clause

asm
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm/9.1
* License: BSD-3-Clause

quartz
* Maven Artifact: org.quartz-scheduler/quartz/2.3.0
* License: Apache-2.0

reactive-streams
* Project: http://www.reactive-streams.org/
* Source: scm:git:git@github.com:reactive-streams/reactive-streams.git
* Maven Artifact: org.reactivestreams/reactive-streams/1.0.3
* License: CC0-1.0

Reflections
* Project: http://github.com/ronmamo/reflections
* Source: scm:git:git://github.com/ronmamo/reflections.git
* Maven Artifact: org.reflections/reflections/0.9.12
* License: MIT

Simple XML
* Project: http://simple.sourceforge.net
* Source: scm:svn:https://simple.svn.sourceforge.net/svnroot/simple/tags/simple-xml-2.7.1
* Maven Artifact: org.simpleframework/simple-xml/2.7.1
* License: Apache-2.0

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.10
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.22
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.25
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.26
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.28
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.30
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.32
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.5
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.7
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/2.0.0-alpha1
* License: MIT

SLF4J Simple Binding
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-simple/1.7.5
* License: MIT

SnakeYAML
* Project: http://www.snakeyaml.org
* Source: scm:hg:http://bitbucket.org/asomov/snakeyaml
* Maven Artifact: org.yaml/snakeyaml/1.23
* License: Apache-2.0

SnakeYAML
* Project: http://www.snakeyaml.org
* Source: scm:git:http://bitbucket.org/asomov/snakeyaml
* Maven Artifact: org.yaml/snakeyaml/1.27
* License: Apache-2.0

SnakeYAML
* Project: http://www.snakeyaml.org
* Source: scm:git:http://bitbucket.org/asomov/snakeyaml
* Maven Artifact: org.yaml/snakeyaml/1.28
* License: Apache-2.0

AWS Java SDK :: Annotations
* Maven Artifact: software.amazon.awssdk/annotations/2.16.60
* License: Apache-2.0

AWS Java SDK :: HTTP Clients :: Apache
* Maven Artifact: software.amazon.awssdk/apache-client/2.16.60
* License: Apache-2.0

AWS Java SDK :: Arns
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/arns/2.16.60
* License: Apache-2.0

AWS Java SDK :: Auth
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/auth/2.16.60
* License: Apache-2.0

AWS Java SDK :: AWS Core
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/aws-core/2.16.60
* License: Apache-2.0

AWS Java SDK :: Core :: Protocols :: AWS Query Protocol
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/aws-query-protocol/2.16.60
* License: Apache-2.0

AWS Java SDK :: Core :: Protocols :: AWS Xml Protocol
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/aws-xml-protocol/2.16.60
* License: Apache-2.0

AWS Java SDK :: HTTP Client Interface
* Maven Artifact: software.amazon.awssdk/http-client-spi/2.16.60
* License: Apache-2.0

AWS Java SDK :: Services :: AWS IAM
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/iam/2.16.60
* License: Apache-2.0

AWS Java SDK :: Metrics SPI
* Maven Artifact: software.amazon.awssdk/metrics-spi/2.16.60
* License: Apache-2.0

AWS Java SDK :: HTTP Clients :: Netty Non-Blocking I/O
* Maven Artifact: software.amazon.awssdk/netty-nio-client/2.16.60
* License: Apache-2.0

AWS Java SDK :: Profiles
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/profiles/2.16.60
* License: Apache-2.0

AWS Java SDK :: Core :: Protocols :: Protocol Core
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/protocol-core/2.16.60
* License: Apache-2.0

AWS Java SDK :: Regions
* Maven Artifact: software.amazon.awssdk/regions/2.16.60
* License: Apache-2.0

AWS Java SDK :: Services :: Amazon S3
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/s3/2.16.60
* License: Apache-2.0

AWS Java SDK :: SDK Core
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/sdk-core/2.16.60
* License: Apache-2.0

AWS Java SDK :: Services :: AWS STS
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/sts/2.16.60
* License: Apache-2.0

AWS Java SDK :: Utilities
* Maven Artifact: software.amazon.awssdk/utils/2.16.60
* License: Apache-2.0

AWS Event Stream
* Project: https://github.com/awslabs/aws-eventstream-java
* Maven Artifact: software.amazon.eventstream/eventstream/1.0.1
* License: Apache-2.0

StAX API
* Project: http://stax.codehaus.org/
* Maven Artifact: stax/stax-api/1.0.1
* License: CDDL-1.0

StAX
* Project: http://stax.codehaus.org/
* Source: scm:cvs:pserver:anonymous@cvs.stax.codehaus.org:/home/projects/stax/scm:stax
* Maven Artifact: stax/stax/1.2.0
* License: Apache-2.0

The International Data Spaces (IDS) Information Model
* Project: https://github.com/International-Data-Spaces-Association/InformationModel
* Source: scm:git:https://github.com/International-Data-Spaces-Association/InformationModel.git
* Maven Artifact: de.fraunhofer.iais.eis.ids.infomodel/java/4.2.7
* License: Apache-2.0

The International Data Spaces (IDS) Information Model Util
* Project: https://github.com/International-Data-Spaces-Association/InformationModel
* Source: scm:git:https://github.com/International-Data-Spaces-Association/InformationModel.git
* Maven Artifact: de.fraunhofer.iais.eis.infomodel/util/4.2.7
* License: Apache-2.0

## Cryptography

Content may contain encryption software. The country in which you are currently may have restrictions on the import, possession, and use, and/or re-export to another country, of encryption software. BEFORE using any encryption software, please check the country's laws, regulations and policies concerning the import, possession, or use, and re-export of encryption software, to see if this is permitted.