/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.lease;

import java.sql.Connection;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.transaction.TransactionContext;
import org.eclipse.dataspaceconnector.sql.lease.LeaseStatements;
import org.eclipse.dataspaceconnector.sql.lease.SqlLeaseContext;

public class SqlLeaseContextBuilder {
    private final TransactionContext trxContext;
    private final LeaseStatements statements;
    private final Clock clock;
    private String leaseHolder;
    private Duration leaseDuration;

    private SqlLeaseContextBuilder(TransactionContext trxContext, LeaseStatements statements, String leaseHolder, Clock clock) {
        this.trxContext = trxContext;
        this.statements = statements;
        this.leaseHolder = leaseHolder;
        this.clock = clock;
    }

    public static SqlLeaseContextBuilder with(TransactionContext trxContext, String leaseHolder, LeaseStatements statements, Clock clock) {
        Objects.requireNonNull(trxContext, "trxContext");
        Objects.requireNonNull(leaseHolder, "leaseHolder");
        Objects.requireNonNull(statements, "statements");
        return new SqlLeaseContextBuilder(trxContext, statements, leaseHolder, clock);
    }

    public SqlLeaseContextBuilder by(String leaseHolder) {
        this.leaseHolder = leaseHolder;
        return this;
    }

    public SqlLeaseContextBuilder forTime(Duration duration) {
        this.leaseDuration = duration;
        return this;
    }

    public SqlLeaseContext withConnection(Connection connection) {
        Objects.requireNonNull(connection, "connection");
        return new SqlLeaseContext(this.trxContext, this.statements, this.leaseHolder, this.clock, this.leaseDuration, connection);
    }
}

