/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.lease;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Duration;
import java.util.function.Supplier;
import org.eclipse.dataspaceconnector.spi.transaction.TransactionContext;
import org.eclipse.dataspaceconnector.sql.lease.LeaseStatements;
import org.eclipse.dataspaceconnector.sql.lease.SqlLease;
import org.eclipse.dataspaceconnector.sql.lease.SqlLeaseContextBuilder;

public class LeaseUtil {
    private final SqlLeaseContextBuilder leaseContextBuilder;
    private final Supplier<Connection> connectionSupplier;

    public LeaseUtil(TransactionContext context, Supplier<Connection> connectionSupplier, LeaseStatements statements, Clock clock) {
        this.connectionSupplier = connectionSupplier;
        this.leaseContextBuilder = SqlLeaseContextBuilder.with((TransactionContext)context, (String)"test", (LeaseStatements)statements, (Clock)clock);
    }

    public void leaseEntity(String tpId, String leaseHolder) {
        try (Connection conn = this.connectionSupplier.get();){
            this.leaseContextBuilder.by(leaseHolder).withConnection(conn).acquireLease(tpId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void leaseEntity(String tpId, String leaseHolder, Duration leaseDuration) {
        try (Connection conn = this.connectionSupplier.get();){
            this.leaseContextBuilder.by(leaseHolder).forTime(leaseDuration).withConnection(conn).acquireLease(tpId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLeased(String id, String connectorName) {
        boolean bl;
        block8: {
            Connection conn = this.connectionSupplier.get();
            try {
                SqlLease lease = this.leaseContextBuilder.withConnection(conn).getLease(id);
                boolean bl2 = bl = lease != null && lease.getLeasedBy().equals(connectorName);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            conn.close();
        }
        return bl;
    }
}

