/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Iterator;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.ListBinding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValueBinding;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.ValidationStatusMap;
import org.eclipse.core.runtime.Assert;

public class DataBindingContext {
    private WritableList bindings;
    private IObservableList unmodifiableBindings;
    private IObservableMap validationStatusMap;
    private Realm validationRealm;

    public DataBindingContext() {
        this(Realm.getDefault());
    }

    public DataBindingContext(Realm validationRealm) {
        Assert.isNotNull((Object)validationRealm);
        this.validationRealm = validationRealm;
        this.bindings = new WritableList(validationRealm);
        this.unmodifiableBindings = Observables.unmodifiableObservableList(this.bindings);
        this.validationStatusMap = new ValidationStatusMap(validationRealm, this.bindings);
    }

    public final Binding bindValue(IObservableValue targetObservableValue, IObservableValue modelObservableValue, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        UpdateValueStrategy targetToModelStrategy = targetToModel != null ? targetToModel : this.createTargetToModelUpdateValueStrategy(targetObservableValue, modelObservableValue);
        UpdateValueStrategy modelToTargetStrategy = modelToTarget != null ? modelToTarget : this.createModelToTargetUpdateValueStrategy(modelObservableValue, targetObservableValue);
        targetToModelStrategy.fillDefaults(targetObservableValue, modelObservableValue);
        modelToTargetStrategy.fillDefaults(modelObservableValue, targetObservableValue);
        ValueBinding result = new ValueBinding(targetObservableValue, modelObservableValue, targetToModelStrategy, modelToTargetStrategy);
        result.init(this);
        return result;
    }

    protected UpdateValueStrategy createModelToTargetUpdateValueStrategy(IObservableValue fromValue, IObservableValue toValue) {
        return new UpdateValueStrategy();
    }

    protected UpdateValueStrategy createTargetToModelUpdateValueStrategy(IObservableValue fromValue, IObservableValue toValue) {
        return new UpdateValueStrategy();
    }

    public final Binding bindList(IObservableList targetObservableList, IObservableList modelObservableList, UpdateListStrategy targetToModel, UpdateListStrategy modelToTarget) {
        UpdateListStrategy targetToModelStrategy = targetToModel != null ? targetToModel : this.createTargetToModelUpdateListStrategy(targetObservableList, modelObservableList);
        UpdateListStrategy modelToTargetStrategy = modelToTarget != null ? modelToTarget : this.createModelToTargetUpdateListStrategy(modelObservableList, targetObservableList);
        targetToModelStrategy.fillDefaults(targetObservableList, modelObservableList);
        modelToTargetStrategy.fillDefaults(modelObservableList, targetObservableList);
        ListBinding result = new ListBinding(targetObservableList, modelObservableList, targetToModelStrategy, modelToTargetStrategy);
        result.init(this);
        return result;
    }

    protected UpdateListStrategy createModelToTargetUpdateListStrategy(IObservableList modelObservableList, IObservableList targetObservableList) {
        return new UpdateListStrategy();
    }

    protected UpdateListStrategy createTargetToModelUpdateListStrategy(IObservableList targetObservableList, IObservableList modelObservableList) {
        return new UpdateListStrategy();
    }

    public final void dispose() {
        Binding[] bindingArray = (Binding[])this.bindings.toArray(new Binding[this.bindings.size()]);
        int i = 0;
        while (i < bindingArray.length) {
            bindingArray[i].dispose();
            ++i;
        }
    }

    public final IObservableList getBindings() {
        return this.unmodifiableBindings;
    }

    public final IObservableMap getValidationStatusMap() {
        return this.validationStatusMap;
    }

    public void addBinding(Binding binding) {
        this.bindings.add(binding);
    }

    public final void updateModels() {
        Iterator it = this.bindings.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            binding.updateTargetToModel();
        }
    }

    public final void updateTargets() {
        Iterator it = this.bindings.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            binding.updateModelToTarget();
        }
    }

    public boolean removeBinding(Binding binding) {
        return this.bindings.remove(binding);
    }

    public final Realm getValidationRealm() {
        return this.validationRealm;
    }
}

