/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction0;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectFloatMap;
import org.eclipse.collections.api.map.primitive.MutableFloatObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectFloatMap;
import org.eclipse.collections.api.map.primitive.ObjectFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ObjectFloatPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.primitive.ObjectFloatMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectFloatMap;

public final class UnmodifiableObjectFloatMap<K>
implements MutableObjectFloatMap<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectFloatMap<K> map;

    public UnmodifiableObjectFloatMap(MutableObjectFloatMap<K> map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableObjectFloatMap on a null map");
        }
        this.map = map;
    }

    private boolean isAbsent(float result, K key) {
        return result == 0.0f && !this.containsKey(key);
    }

    private float getIfAbsentThrow(K key) {
        float result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(K key, float value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ObjectFloatMap<? extends K> map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public float removeKeyIfAbsent(K key, float value) {
        throw new UnsupportedOperationException("Cannot call removeKeyIfAbsent() on " + this.getClass().getSimpleName());
    }

    public float getIfAbsentPut(K key, float value) {
        return this.getIfAbsentThrow(key);
    }

    public float getIfAbsentPut(K key, FloatFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public float getIfAbsentPutWithKey(K key, FloatFunction<? super K> function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> float getIfAbsentPutWith(K key, FloatFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public float updateValue(K key, float initialValueIfAbsent, FloatToFloatFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public float addToValue(K key, float toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public float get(Object key) {
        return this.map.get(key);
    }

    public float getOrThrow(Object key) {
        return this.map.getOrThrow(key);
    }

    public float getIfAbsent(Object key, float ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectFloatProcedure<? super K> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public MutableObjectFloatMap<K> select(ObjectFloatPredicate<? super K> predicate) {
        return this.map.select(predicate);
    }

    public MutableObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> predicate) {
        return this.map.reject(predicate);
    }

    public MutableFloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)this.map.floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableFloatCollection select(FloatPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableFloatCollection reject(FloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V1> MutableCollection<V1> collect(FloatToObjectFunction<? extends V1> function) {
        return this.map.collect(function);
    }

    public double sum() {
        return this.map.sum();
    }

    public float max() {
        return this.map.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public float min() {
        return this.map.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public float[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return this.map.toSortedList();
    }

    public float[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(float value) {
        return this.map.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.map.containsAll(source);
    }

    public MutableFloatList toList() {
        return this.map.toList();
    }

    public MutableFloatSet toSet() {
        return this.map.toSet();
    }

    public MutableFloatBag toBag() {
        return this.map.toBag();
    }

    public LazyFloatIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableObjectFloatMap<K> withKeyValue(K key, float value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableObjectFloatMap<K> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableObjectFloatMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableObjectFloatMap<K> asUnmodifiable() {
        return this;
    }

    public MutableObjectFloatMap<K> asSynchronized() {
        return new SynchronizedObjectFloatMap(this);
    }

    public ImmutableObjectFloatMap<K> toImmutable() {
        return ObjectFloatMaps.immutable.withAll((ObjectFloatMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.map.values());
    }

    public LazyIterable<K> keysView() {
        return this.map.keysView();
    }

    public RichIterable<ObjectFloatPair<K>> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableFloatObjectMap<K> flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

